/*
 * Decompiled with CFR 0.152.
 */
package com.ib.controller;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class Formats {
    private static final Format FMT8 = new DecimalFormat("#,##0.00000000");
    private static final Format FMT2 = new DecimalFormat("#,##0.00");
    private static final Format FMT0 = new DecimalFormat("#,##0");
    private static final Format PCT = new DecimalFormat("0.0%");
    private static final ThreadLocal<DateFormat> GMT_DATE_TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return simpleDateFormat;
    });
    private static final ThreadLocal<DateFormat> DATE_TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd-HH:mm:ss"));
    private static final ThreadLocal<DateFormat> TIME_FORMAT_CACHE = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss"));

    public static String fmt8(double d) {
        return d == Double.MAX_VALUE ? null : FMT8.format(d);
    }

    public static String fmt(double d) {
        return d == Double.MAX_VALUE ? null : FMT2.format(d);
    }

    public static String fmtNz(double d) {
        return d == Double.MAX_VALUE || d == 0.0 ? null : FMT2.format(d);
    }

    public static String fmt0(double d) {
        return d == Double.MAX_VALUE ? null : FMT0.format(d);
    }

    public static String fmtPct(double d) {
        return d == Double.MAX_VALUE ? null : PCT.format(d);
    }

    public static String fmtDate(long l) {
        return DATE_TIME_FORMAT_CACHE.get().format(new Date(l));
    }

    public static String fmtDateGmt(long l) {
        return GMT_DATE_TIME_FORMAT_CACHE.get().format(new Date(l));
    }

    public static String fmtTime(long l) {
        return TIME_FORMAT_CACHE.get().format(new Date(l));
    }
}

