/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.OrderType;
import com.ib.controller.ApiController;
import com.ib.controller.Formats;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class Util {
    public static final String SPACE_SYMBOL = " ";
    public static final String EQUALS_SIGN = "=";

    public static String decimalToStringNoZero(Decimal decimal) {
        return Decimal.isValidNotZeroValue(decimal) ? decimal.toString() : "";
    }

    public static boolean isValidValue(double d) {
        return d != Double.MAX_VALUE && !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static boolean StringIsEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String NormalizeString(String string) {
        return string != null ? string : "";
    }

    public static int StringCompare(String string, String string2) {
        return Util.NormalizeString(string).compareTo(Util.NormalizeString(string2));
    }

    public static int StringCompareIgnCase(String string, String string2) {
        return Util.NormalizeString(string).compareToIgnoreCase(Util.NormalizeString(string2));
    }

    public static boolean listsEqualUnordered(List<?> list, List<?> list2) {
        int n;
        if (list == list2) {
            return true;
        }
        int n2 = list == null ? 0 : list.size();
        int n3 = n = list2 == null ? 0 : list2.size();
        if (n2 != n) {
            return false;
        }
        if (n2 == 0) {
            return true;
        }
        boolean[] blArray = new boolean[n];
        for (int i = 0; i < n2; ++i) {
            int n4;
            Object obj = list.get(i);
            for (n4 = 0; n4 < n; ++n4) {
                if (blArray[n4] || !obj.equals(list2.get(n4))) continue;
                blArray[n4] = true;
                break;
            }
            if (n4 < n) continue;
            return false;
        }
        return true;
    }

    public static String LongMaxString(long l) {
        return l == Long.MAX_VALUE ? "" : String.valueOf(l);
    }

    public static String IntMaxString(int n) {
        return n == Integer.MAX_VALUE ? "" : String.valueOf(n);
    }

    public static String DoubleMaxString(double d) {
        return Util.DoubleMaxString(d, "");
    }

    public static String DoubleMaxString(double d, String string) {
        return d == Double.MAX_VALUE ? string : new DecimalFormat("0.########").format(d);
    }

    public static String UnixMillisecondsToString(long l, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(l);
        return simpleDateFormat.format(calendar.getTime());
    }

    public static String UnixSecondsToString(long l, String string) {
        return Util.UnixMillisecondsToString(l * 1000L, string);
    }

    public static List<ContractDetails> lookupContract(ApiController apiController, Contract contract) {
        if (apiController == null) {
            return new ArrayList<ContractDetails>();
        }
        final CompletableFuture completableFuture = new CompletableFuture();
        apiController.reqContractDetails(contract, new ApiController.IContractDetailsHandler(){
            private final List<ContractDetails> contractDetails = new ArrayList<ContractDetails>();

            @Override
            public void contractDetails(List<ContractDetails> list) {
                this.contractDetails.addAll(list);
                completableFuture.complete(this.contractDetails);
            }
        });
        try {
            return (List)completableFuture.get();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            Thread.currentThread().interrupt();
            return new ArrayList<ContractDetails>();
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return new ArrayList<ContractDetails>();
        }
    }

    public static void appendNonEmptyString(StringBuilder stringBuilder, String string, String string2, String string3) {
        if (!Util.StringIsEmpty(string2) && !string2.equals(string3)) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(string2);
        }
    }

    public static void appendNonEmptyString(StringBuilder stringBuilder, String string, String string2) {
        if (!Util.StringIsEmpty(string2)) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(string2);
        }
    }

    public static void appendPositiveIntValue(StringBuilder stringBuilder, String string, int n) {
        if (n > 0) {
            Util.appendValidIntValue(stringBuilder, string, n);
        }
    }

    public static void appendValidIntValue(StringBuilder stringBuilder, String string, int n) {
        if (n != Integer.MAX_VALUE) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(Util.IntMaxString(n));
        }
    }

    public static void appendPositiveDoubleValue(StringBuilder stringBuilder, String string, double d) {
        if (d > 0.0) {
            Util.appendValidDoubleValue(stringBuilder, string, d);
        }
    }

    public static void appendValidDoubleValue(StringBuilder stringBuilder, String string, double d) {
        if (d != Double.MAX_VALUE) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(Util.DoubleMaxString(d));
        }
    }

    public static void appendBooleanFlag(StringBuilder stringBuilder, String string, Boolean bl) {
        if (bl != null && bl.booleanValue()) {
            stringBuilder.append(SPACE_SYMBOL).append(string);
        }
    }

    public static void appendBooleanFlag(StringBuilder stringBuilder, String string, int n) {
        if (n > 0) {
            stringBuilder.append(SPACE_SYMBOL).append(string);
        }
    }

    public static void appendValidDoubleValue(StringBuilder stringBuilder, String string, String string2) {
        Double d;
        if (!Util.StringIsEmpty(string2) && (d = Double.valueOf(Double.parseDouble(string2))) != Double.MAX_VALUE) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(Formats.fmt(d));
        }
    }

    public static void appendValidLongValue(StringBuilder stringBuilder, String string, long l) {
        if (l != Long.MAX_VALUE) {
            stringBuilder.append(SPACE_SYMBOL).append(string).append(EQUALS_SIGN).append(Util.LongMaxString(l));
        }
    }

    public static boolean IsVolOrder(OrderType orderType) {
        return orderType == OrderType.VOL;
    }

    public static boolean IsPegBenchOrder(OrderType orderType) {
        return orderType == OrderType.PEG_BENCH;
    }

    public static boolean IsPegMidOrder(OrderType orderType) {
        return orderType == OrderType.PEG_MID;
    }

    public static Boolean IsPegBestOrder(OrderType orderType) {
        return orderType == OrderType.PEG_BEST;
    }
}

