/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ContractCondition;
import com.ib.client.ContractLookuper;
import com.ib.client.OrderConditionType;
import com.ib.client.Util;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Optional;

public class PriceCondition
extends ContractCondition {
    public static final OrderConditionType conditionType = OrderConditionType.Price;
    private double m_price;
    private int m_triggerMethod;
    private static String[] mthdNames = new String[]{"default", "double bid/ask", "last", "double last", "bid/ask", "", "", "last of bid/ask", "mid-point"};

    protected PriceCondition() {
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public double price() {
        return this.m_price;
    }

    public void price(double d) {
        this.m_price = d;
    }

    @Override
    public String toString(ContractLookuper contractLookuper) {
        return this.strTriggerMethod() + " " + super.toString(contractLookuper);
    }

    public int triggerMethod() {
        return this.m_triggerMethod;
    }

    String strTriggerMethod() {
        return mthdNames[this.triggerMethod()];
    }

    public void triggerMethod(int n) {
        this.m_triggerMethod = n;
    }

    @Override
    protected String valueToString() {
        return Util.DoubleMaxString(this.m_price);
    }

    @Override
    protected void valueFromString(String string) {
        this.m_price = Double.parseDouble(string);
    }

    @Override
    public void readFrom(ObjectInput objectInput) throws IOException {
        super.readFrom(objectInput);
        this.m_triggerMethod = objectInput.readInt();
    }

    @Override
    public void writeTo(ObjectOutput objectOutput) throws IOException {
        super.writeTo(objectOutput);
        objectOutput.writeInt(this.m_triggerMethod);
    }

    public static int triggerMethodFromString(String string) {
        return Arrays.asList(mthdNames).indexOf(string);
    }

    @Override
    public boolean tryToParse(String string3) {
        Optional<String> optional = Arrays.stream(mthdNames).filter(string -> !string.isEmpty()).filter(string2 -> string3.startsWith((String)string2)).sorted((string, string2) -> string2.length() - string.length()).findFirst();
        if (!optional.isPresent()) {
            return false;
        }
        try {
            this.m_triggerMethod = PriceCondition.triggerMethodFromString(optional.get());
            return super.tryToParse(string3.substring(string3.indexOf(optional.get()) + optional.get().length() + 1));
        }
        catch (Exception exception) {
            return false;
        }
    }
}

