/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ExecutionCondition;
import com.ib.client.MarginCondition;
import com.ib.client.OrderConditionType;
import com.ib.client.PercentChangeCondition;
import com.ib.client.PriceCondition;
import com.ib.client.TimeCondition;
import com.ib.client.VolumeCondition;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OrderCondition {
    protected static final String SPACE = " ";
    protected static final String EMPTY = "";
    private static final String AND = " and";
    private static final String OR = " or";
    private OrderConditionType m_type;
    private boolean m_isConjunctionConnection;

    public void readFrom(ObjectInput objectInput) throws IOException {
        this.conjunctionConnection(objectInput.readUTF().compareToIgnoreCase("a") == 0);
    }

    public void writeTo(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeUTF(this.conjunctionConnection() ? "a" : "o");
    }

    public String toString() {
        return this.conjunctionConnection() ? AND : OR;
    }

    public boolean conjunctionConnection() {
        return this.m_isConjunctionConnection;
    }

    public void conjunctionConnection(boolean bl) {
        this.m_isConjunctionConnection = bl;
    }

    public OrderConditionType type() {
        return this.m_type;
    }

    public static OrderCondition create(OrderConditionType orderConditionType) {
        OrderCondition orderCondition;
        switch (orderConditionType) {
            case Execution: {
                orderCondition = new ExecutionCondition();
                break;
            }
            case Margin: {
                orderCondition = new MarginCondition();
                break;
            }
            case PercentChange: {
                orderCondition = new PercentChangeCondition();
                break;
            }
            case Price: {
                orderCondition = new PriceCondition();
                break;
            }
            case Time: {
                orderCondition = new TimeCondition();
                break;
            }
            case Volume: {
                orderCondition = new VolumeCondition();
                break;
            }
            default: {
                return null;
            }
        }
        orderCondition.m_type = orderConditionType;
        return orderCondition;
    }

    public boolean tryToParse(String string) {
        this.m_isConjunctionConnection = string.equals(AND);
        return this.m_isConjunctionConnection || string.equals(OR);
    }
}

