/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.OrderCondition;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class OperatorCondition
extends OrderCondition {
    private static final String HEADER = " is ";
    private static final String IS_MORE = ">=";
    private static final String IS_LESS = "<=";
    private boolean m_isMore;

    protected abstract String valueToString();

    protected abstract void valueFromString(String var1);

    @Override
    public void readFrom(ObjectInput objectInput) throws IOException {
        super.readFrom(objectInput);
        this.m_isMore = objectInput.readBoolean();
        this.valueFromString(objectInput.readUTF());
    }

    @Override
    public String toString() {
        return HEADER + (this.isMore() ? ">= " : "<= ") + this.valueToString() + super.toString();
    }

    @Override
    public void writeTo(ObjectOutput objectOutput) throws IOException {
        super.writeTo(objectOutput);
        objectOutput.writeBoolean(this.m_isMore);
        objectOutput.writeUTF(this.valueToString());
    }

    public boolean isMore() {
        return this.m_isMore;
    }

    public void isMore(boolean bl) {
        this.m_isMore = bl;
    }

    @Override
    public boolean tryToParse(String string) {
        if (!string.startsWith(HEADER)) {
            return false;
        }
        try {
            string = string.replace(HEADER, "");
            if (!string.startsWith(IS_MORE) && !string.startsWith(IS_LESS)) {
                return false;
            }
            this.m_isMore = string.startsWith(IS_MORE);
            if (super.tryToParse(string.substring(string.lastIndexOf(" ")))) {
                string = string.substring(0, string.lastIndexOf(" "));
            }
            this.valueFromString(string.substring(3));
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

