/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Decimal;

public class HistogramEntry
implements Comparable<HistogramEntry> {
    private double price;
    private Decimal size;

    public double price() {
        return this.price;
    }

    public void price(double d) {
        this.price = d;
    }

    public Decimal size() {
        return this.size;
    }

    public void size(Decimal decimal) {
        this.size = decimal;
    }

    public HistogramEntry(double d, Decimal decimal) {
        this.price = d;
        this.size = decimal;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof HistogramEntry)) {
            return false;
        }
        HistogramEntry histogramEntry = (HistogramEntry)object;
        return Double.compare(this.price, histogramEntry.price) == 0 && Decimal.compare(this.size, histogramEntry.size) == 0;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.price);
        int n = (int)(l ^ l >>> 32);
        n = 31 * n + this.size.hashCode();
        return n;
    }

    @Override
    public int compareTo(HistogramEntry histogramEntry) {
        int n = Double.compare(this.price, histogramEntry.price);
        if (n != 0) {
            return n;
        }
        return Decimal.compare(this.size, histogramEntry.size);
    }

    public String toString() {
        return "HistogramEntry{price=" + this.price + ", size=" + this.size + '}';
    }
}

