/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.OrderCondition;
import com.ib.client.OrderConditionType;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ExecutionCondition
extends OrderCondition {
    public static final OrderConditionType conditionType = OrderConditionType.Execution;
    private static final String HEADER = "trade occurs for ";
    private static final String SYMBOL_SUFFIX = " symbol on ";
    private static final String EXCHANGE_SUFFIX = " exchange for ";
    private static final String SECTYPE_SUFFIX = " security type";
    private String m_exchange;
    private String m_secType;
    private String m_symbol;

    protected ExecutionCondition() {
    }

    @Override
    public void readFrom(ObjectInput objectInput) throws IOException {
        super.readFrom(objectInput);
        this.m_secType = objectInput.readUTF();
        this.m_exchange = objectInput.readUTF();
        this.m_symbol = objectInput.readUTF();
    }

    @Override
    public String toString() {
        return HEADER + this.m_symbol + SYMBOL_SUFFIX + this.m_exchange + EXCHANGE_SUFFIX + this.m_secType + SECTYPE_SUFFIX + super.toString();
    }

    @Override
    public void writeTo(ObjectOutput objectOutput) throws IOException {
        super.writeTo(objectOutput);
        objectOutput.writeUTF(this.m_secType);
        objectOutput.writeUTF(this.m_exchange);
        objectOutput.writeUTF(this.m_symbol);
    }

    public String exchange() {
        return this.m_exchange;
    }

    public void exchange(String string) {
        this.m_exchange = string;
    }

    public String secType() {
        return this.m_secType;
    }

    public void secType(String string) {
        this.m_secType = string;
    }

    public String symbol() {
        return this.m_symbol;
    }

    public void symbol(String string) {
        this.m_symbol = string;
    }

    @Override
    public boolean tryToParse(String string) {
        if (!string.startsWith(HEADER)) {
            return false;
        }
        try {
            string = string.replace(HEADER, "");
            this.m_symbol = string.substring(0, string.indexOf(SYMBOL_SUFFIX));
            this.m_exchange = string.substring(string.indexOf(SYMBOL_SUFFIX) + SYMBOL_SUFFIX.length(), string.indexOf(EXCHANGE_SUFFIX));
            this.m_secType = string.substring(string.indexOf(EXCHANGE_SUFFIX) + EXCHANGE_SUFFIX.length(), string.indexOf(SECTYPE_SUFFIX));
            string = string.substring(string.indexOf(SECTYPE_SUFFIX) + SECTYPE_SUFFIX.length());
            return super.tryToParse(string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

