/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.Execution;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.MarketDataType;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.OrderState;
import com.ib.client.PriceIncrement;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import com.ib.client.Types;
import com.ib.client.Util;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EWrapperMsgGenerator {
    public static final String SCANNER_PARAMETERS = "SCANNER PARAMETERS:";
    public static final String FINANCIAL_ADVISOR = "FA:";

    public static String tickPrice(int n, int n2, double d, TickAttrib tickAttrib) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + Util.DoubleMaxString(d) + " " + (tickAttrib.canAutoExecute() ? " canAutoExecute" : " noAutoExecute") + " pastLimit = " + tickAttrib.pastLimit() + (n2 == TickType.BID.index() || n2 == TickType.ASK.index() ? " preOpen = " + tickAttrib.preOpen() : "");
    }

    public static String tickSize(int n, int n2, Decimal decimal) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + decimal;
    }

    public static String tickOptionComputation(int n, int n2, int n3, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return "id=" + n + "  " + TickType.getField(n2) + ": tickAttrib = " + Util.IntMaxString(n3) + " impliedVol = " + Util.DoubleMaxString(d, "N/A") + " delta = " + Util.DoubleMaxString(d2, "N/A") + " gamma = " + Util.DoubleMaxString(d5, "N/A") + " vega = " + Util.DoubleMaxString(d6, "N/A") + " theta = " + Util.DoubleMaxString(d7, "N/A") + " optPrice = " + Util.DoubleMaxString(d3, "N/A") + " pvDividend = " + Util.DoubleMaxString(d4, "N/A") + " undPrice = " + Util.DoubleMaxString(d8, "N/A");
    }

    public static String tickGeneric(int n, int n2, double d) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + Util.DoubleMaxString(d);
    }

    public static String tickString(int n, int n2, String string) {
        return "id=" + n + "  " + TickType.getField(n2) + "=" + string;
    }

    public static String tickEFP(int n, int n2, double d, String string, double d2, int n3, String string2, double d3, double d4) {
        return "id=" + n + "  " + TickType.getField(n2) + ": basisPoints = " + Util.DoubleMaxString(d) + "/" + string + " impliedFuture = " + Util.DoubleMaxString(d2) + " holdDays = " + Util.IntMaxString(n3) + " futureLastTradeDate = " + string2 + " dividendImpact = " + Util.DoubleMaxString(d3) + " dividends to expiry = " + Util.DoubleMaxString(d4);
    }

    public static String orderStatus(int n, String string, Decimal decimal, Decimal decimal2, double d, int n2, int n3, double d2, int n4, String string2, double d3) {
        return "order status: orderId=" + n + " clientId=" + Util.IntMaxString(n4) + " permId=" + Util.IntMaxString(n2) + " status=" + string + " filled=" + decimal + " remaining=" + decimal2 + " avgFillPrice=" + Util.DoubleMaxString(d) + " lastFillPrice=" + Util.DoubleMaxString(d2) + " parent Id=" + Util.IntMaxString(n3) + " whyHeld=" + string2 + " mktCapPrice=" + Util.DoubleMaxString(d3);
    }

    public static String openOrder(int n, Contract contract, Order order, OrderState orderState) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("open order:");
        EWrapperMsgGenerator.appendOrderFields(stringBuilder, n, contract, order, orderState, true);
        return stringBuilder.toString();
    }

    public static String openOrderEnd() {
        return " =============== end ===============";
    }

    public static String updateAccountValue(String string, String string2, String string3, String string4) {
        return "updateAccountValue: " + string + " " + string2 + " " + string3 + " " + string4;
    }

    public static String updatePortfolio(Contract contract, Decimal decimal, double d, double d2, double d3, double d4, double d5, String string) {
        return "updatePortfolio: " + EWrapperMsgGenerator.contractMsg(contract) + decimal + " " + Util.DoubleMaxString(d) + " " + Util.DoubleMaxString(d2) + " " + Util.DoubleMaxString(d3) + " " + Util.DoubleMaxString(d4) + " " + Util.DoubleMaxString(d5) + " " + string;
    }

    public static String updateAccountTime(String string) {
        return "updateAccountTime: " + string;
    }

    public static String accountDownloadEnd(String string) {
        return "accountDownloadEnd: " + string;
    }

    public static String nextValidId(int n) {
        return "Next Valid Order ID: " + n;
    }

    public static String contractDetails(int n, ContractDetails contractDetails) {
        Contract contract = contractDetails.contract();
        return "reqId = " + n + " ===================================\n ---- Contract Details begin ----\n" + EWrapperMsgGenerator.contractMsg(contract) + EWrapperMsgGenerator.contractDetailsMsg(contractDetails) + " ---- Contract Details End ----\n";
    }

    private static String contractDetailsMsg(ContractDetails contractDetails) {
        return "marketName = " + contractDetails.marketName() + "\nminTick = " + Util.DoubleMaxString(contractDetails.minTick()) + "\nprice magnifier = " + Util.IntMaxString(contractDetails.priceMagnifier()) + "\norderTypes = " + contractDetails.orderTypes() + "\nvalidExchanges = " + contractDetails.validExchanges() + "\nunderConId = " + Util.IntMaxString(contractDetails.underConid()) + "\nlongName = " + contractDetails.longName() + "\ncontractMonth = " + contractDetails.contractMonth() + "\nindustry = " + contractDetails.industry() + "\ncategory = " + contractDetails.category() + "\nsubcategory = " + contractDetails.subcategory() + "\ntimeZoneId = " + contractDetails.timeZoneId() + "\ntradingHours = " + contractDetails.tradingHours() + "\nliquidHours = " + contractDetails.liquidHours() + "\nevRule = " + contractDetails.evRule() + "\nevMultiplier = " + Util.DoubleMaxString(contractDetails.evMultiplier()) + "\naggGroup = " + Util.IntMaxString(contractDetails.aggGroup()) + "\nunderSymbol = " + contractDetails.underSymbol() + "\nunderSecType = " + contractDetails.underSecType() + "\nmarketRuleIds = " + contractDetails.marketRuleIds() + "\nrealExpirationDate = " + contractDetails.realExpirationDate() + "\nlastTradeTime = " + contractDetails.lastTradeTime() + "\nstockType = " + contractDetails.stockType() + "\nminSize = " + contractDetails.minSize() + "\nsizeIncrement = " + contractDetails.sizeIncrement() + "\nsuggestedSizeIncrement = " + contractDetails.suggestedSizeIncrement() + "\n" + EWrapperMsgGenerator.contractDetailsFundData(contractDetails) + EWrapperMsgGenerator.contractDetailsSecIdList(contractDetails);
    }

    private static String contractDetailsFundData(ContractDetails contractDetails) {
        StringBuilder stringBuilder = new StringBuilder();
        if (contractDetails.contract().secType() == Types.SecType.FUND) {
            stringBuilder.append("fundData={\n");
            stringBuilder.append("  fundName=").append(contractDetails.fundName()).append("\n");
            stringBuilder.append("  fundFamily=").append(contractDetails.fundFamily()).append("\n");
            stringBuilder.append("  fundType=").append(contractDetails.fundType()).append("\n");
            stringBuilder.append("  fundFrontLoad=").append(contractDetails.fundFrontLoad()).append("\n");
            stringBuilder.append("  fundBackLoad=").append(contractDetails.fundBackLoad()).append("\n");
            stringBuilder.append("  fundBackLoadTimeInterval=").append(contractDetails.fundBackLoadTimeInterval()).append("\n");
            stringBuilder.append("  fundManagementFee=").append(contractDetails.fundManagementFee()).append("\n");
            stringBuilder.append("  fundClosed=").append(contractDetails.fundClosed()).append("\n");
            stringBuilder.append("  fundClosedForNewInvestors=").append(contractDetails.fundClosedForNewInvestors()).append("\n");
            stringBuilder.append("  fundClosedForNewMoney=").append(contractDetails.fundClosedForNewMoney()).append("\n");
            stringBuilder.append("  fundNotifyAmount=").append(contractDetails.fundNotifyAmount()).append("\n");
            stringBuilder.append("  fundMinimumInitialPurchase=").append(contractDetails.fundMinimumInitialPurchase()).append("\n");
            stringBuilder.append("  fundSubsequentMinimumPurchase=").append(contractDetails.fundSubsequentMinimumPurchase()).append("\n");
            stringBuilder.append("  fundBlueSkyStates=").append(contractDetails.fundBlueSkyStates()).append("\n");
            stringBuilder.append("  fundBlueSkyTerritories=").append(contractDetails.fundBlueSkyTerritories()).append("\n");
            if (contractDetails.fundDistributionPolicyIndicator() != null) {
                stringBuilder.append("  fundDistributionPolicyIndicator=").append(contractDetails.fundDistributionPolicyIndicator().name()).append("\n");
            }
            if (contractDetails.fundAssetType() != null) {
                stringBuilder.append("  fundAssetType=").append(contractDetails.fundAssetType().name()).append("\n");
            }
            stringBuilder.append("}\n");
        }
        return stringBuilder.toString();
    }

    private static String contractMsg(Contract contract) {
        return "conid = " + contract.conid() + "\nsymbol = " + contract.symbol() + "\nsecType = " + contract.getSecType() + "\nlastTradeDateOrContractMonth = " + contract.lastTradeDateOrContractMonth() + "\nlastTradeDate = " + contract.lastTradeDate() + "\nstrike = " + Util.DoubleMaxString(contract.strike()) + "\nright = " + contract.getRight() + "\nmultiplier = " + contract.multiplier() + "\nexchange = " + contract.exchange() + "\nprimaryExch = " + contract.primaryExch() + "\ncurrency = " + contract.currency() + "\nlocalSymbol = " + contract.localSymbol() + "\ntradingClass = " + contract.tradingClass() + "\n";
    }

    public static String bondContractDetails(int n, ContractDetails contractDetails) {
        Contract contract = contractDetails.contract();
        return "reqId = " + n + " ===================================\n ---- Bond Contract Details begin ----\nsymbol = " + contract.symbol() + "\nsecType = " + contract.getSecType() + "\ncusip = " + contractDetails.cusip() + "\ncoupon = " + Util.DoubleMaxString(contractDetails.coupon()) + "\nmaturity = " + contractDetails.maturity() + "\nissueDate = " + contractDetails.issueDate() + "\nratings = " + contractDetails.ratings() + "\nbondType = " + contractDetails.bondType() + "\ncouponType = " + contractDetails.couponType() + "\nconvertible = " + contractDetails.convertible() + "\ncallable = " + contractDetails.callable() + "\nputable = " + contractDetails.putable() + "\ndescAppend = " + contractDetails.descAppend() + "\nexchange = " + contract.exchange() + "\ncurrency = " + contract.currency() + "\nmarketName = " + contractDetails.marketName() + "\ntradingClass = " + contract.tradingClass() + "\nconid = " + contract.conid() + "\nminTick = " + Util.DoubleMaxString(contractDetails.minTick()) + "\norderTypes = " + contractDetails.orderTypes() + "\nvalidExchanges = " + contractDetails.validExchanges() + "\nnextOptionDate = " + contractDetails.nextOptionDate() + "\nnextOptionType = " + contractDetails.nextOptionType() + "\nnextOptionPartial = " + contractDetails.nextOptionPartial() + "\nnotes = " + contractDetails.notes() + "\nlongName = " + contractDetails.longName() + "\nevRule = " + contractDetails.evRule() + "\nevMultiplier = " + Util.DoubleMaxString(contractDetails.evMultiplier()) + "\naggGroup = " + Util.IntMaxString(contractDetails.aggGroup()) + "\nmarketRuleIds = " + contractDetails.marketRuleIds() + "\ntimeZoneId = " + contractDetails.timeZoneId() + "\nlastTradeTime = " + contractDetails.lastTradeTime() + "\nminSize = " + contractDetails.minSize() + "\nsizeIncrement = " + contractDetails.sizeIncrement() + "\nsuggestedSizeIncrement = " + contractDetails.suggestedSizeIncrement() + "\n" + EWrapperMsgGenerator.contractDetailsSecIdList(contractDetails) + " ---- Bond Contract Details End ----\n";
    }

    private static String contractDetailsSecIdList(ContractDetails contractDetails) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("secIdList={");
        if (contractDetails.secIdList() != null) {
            for (TagValue tagValue : contractDetails.secIdList()) {
                stringBuilder.append(tagValue.m_tag).append("=").append(tagValue.m_value).append(',');
            }
            if (!contractDetails.secIdList().isEmpty()) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String contractDetailsEnd(int n) {
        return "reqId = " + n + " =============== end ===============";
    }

    public static String execDetails(int n, Contract contract, Execution execution) {
        return " ---- Execution Details begin ----\nreqId = " + n + "\norderId = " + execution.orderId() + "\nclientId = " + Util.IntMaxString(execution.clientId()) + "\n" + EWrapperMsgGenerator.contractMsg(contract) + "execId = " + execution.execId() + "\ntime = " + execution.time() + "\nacctNumber = " + execution.acctNumber() + "\nexecutionExchange = " + execution.exchange() + "\nside = " + execution.side() + "\nshares = " + execution.shares() + "\nprice = " + Util.DoubleMaxString(execution.price()) + "\npermId = " + Util.IntMaxString(execution.permId()) + "\nliquidation = " + Util.IntMaxString(execution.liquidation()) + "\ncumQty = " + execution.cumQty() + "\navgPrice = " + Util.DoubleMaxString(execution.avgPrice()) + "\norderRef = " + execution.orderRef() + "\nevRule = " + execution.evRule() + "\nevMultiplier = " + Util.DoubleMaxString(execution.evMultiplier()) + "\nmodelCode = " + execution.modelCode() + "\nlastLiquidity = " + (Object)((Object)execution.lastLiquidity()) + "\npendingPriceRevision = " + execution.pendingPriceRevision() + "\n ---- Execution Details end ----\n";
    }

    public static String execDetailsEnd(int n) {
        return "reqId = " + n + " =============== end ===============";
    }

    public static String updateMktDepth(int n, int n2, int n3, int n4, double d, Decimal decimal) {
        return "updateMktDepth: " + n + " " + n2 + " " + n3 + " " + n4 + " " + Util.DoubleMaxString(d) + " " + decimal;
    }

    public static String updateMktDepthL2(int n, int n2, String string, int n3, int n4, double d, Decimal decimal, boolean bl) {
        return "updateMktDepth: " + n + " " + n2 + " " + string + " " + n3 + " " + n4 + " " + Util.DoubleMaxString(d) + " " + decimal + " " + bl;
    }

    public static String updateNewsBulletin(int n, int n2, String string, String string2) {
        return "MsgId=" + n + " :: MsgType=" + Util.IntMaxString(n2) + " :: Origin=" + string2 + " :: Message=" + string;
    }

    public static String managedAccounts(String string) {
        return "Connected : The list of managed accounts are : [" + string + "]";
    }

    public static String receiveFA(int n, String string) {
        return "FA: " + (Object)((Object)Types.FADataType.getById(n)) + " " + string;
    }

    public static String historicalData(int n, String string, double d, double d2, double d3, double d4, Decimal decimal, int n2, Decimal decimal2) {
        return "id=" + n + " date = " + string + " open=" + Util.DoubleMaxString(d) + " high=" + Util.DoubleMaxString(d2) + " low=" + Util.DoubleMaxString(d3) + " close=" + Util.DoubleMaxString(d4) + " volume=" + decimal + " count=" + Util.IntMaxString(n2) + " WAP=" + decimal2;
    }

    public static String historicalDataEnd(int n, String string, String string2) {
        return "id=" + n + " start date = " + string + " end date=" + string2;
    }

    public static String realtimeBar(int n, long l, double d, double d2, double d3, double d4, Decimal decimal, Decimal decimal2, int n2) {
        return "id=" + n + " time = " + Util.LongMaxString(l) + " open=" + Util.DoubleMaxString(d) + " high=" + Util.DoubleMaxString(d2) + " low=" + Util.DoubleMaxString(d3) + " close=" + Util.DoubleMaxString(d4) + " volume=" + decimal + " count=" + Util.IntMaxString(n2) + " WAP=" + decimal2;
    }

    public static String scannerParameters(String string) {
        return "SCANNER PARAMETERS:\n" + string;
    }

    public static String scannerData(int n, int n2, ContractDetails contractDetails, String string, String string2, String string3, String string4) {
        Contract contract = contractDetails.contract();
        return "id = " + n + " rank=" + Util.IntMaxString(n2) + " symbol=" + contract.symbol() + " secType=" + contract.getSecType() + " lastTradeDateOrContractMonth=" + contract.lastTradeDateOrContractMonth() + " strike=" + Util.DoubleMaxString(contract.strike()) + " right=" + contract.getRight() + " exchange=" + contract.exchange() + " currency=" + contract.currency() + " localSymbol=" + contract.localSymbol() + " marketName=" + contractDetails.marketName() + " tradingClass=" + contract.tradingClass() + " distance=" + string + " benchmark=" + string2 + " projection=" + string3 + " legsStr=" + string4;
    }

    public static String scannerDataEnd(int n) {
        return "id = " + n + " =============== end ===============";
    }

    public static String currentTime(long l) {
        return "current time = " + l + " (" + DateFormat.getDateTimeInstance().format(new Date(l * 1000L)) + ")";
    }

    public static String fundamentalData(int n, String string) {
        return "id  = " + n + " len = " + string.length() + '\n' + string;
    }

    public static String deltaNeutralValidation(int n, DeltaNeutralContract deltaNeutralContract) {
        return "id = " + n + " deltaNeutralContract.conId =" + deltaNeutralContract.conid() + " deltaNeutralContract.delta =" + Util.DoubleMaxString(deltaNeutralContract.delta()) + " deltaNeutralContract.price =" + Util.DoubleMaxString(deltaNeutralContract.price());
    }

    public static String tickSnapshotEnd(int n) {
        return "id=" + n + " =============== end ===============";
    }

    public static String marketDataType(int n, int n2) {
        return "id=" + n + " marketDataType = " + MarketDataType.getField(n2);
    }

    public static String commissionReport(CommissionReport commissionReport) {
        return "commission report: execId=" + commissionReport.execId() + " commission=" + Util.DoubleMaxString(commissionReport.commission()) + " currency=" + commissionReport.currency() + " realizedPNL=" + Util.DoubleMaxString(commissionReport.realizedPNL()) + " yield=" + Util.DoubleMaxString(commissionReport.yield()) + " yieldRedemptionDate=" + Util.IntMaxString(commissionReport.yieldRedemptionDate());
    }

    public static String position(String string, Contract contract, Decimal decimal, double d) {
        return " ---- Position begin ----\naccount = " + string + "\n" + EWrapperMsgGenerator.contractMsg(contract) + "position = " + decimal + "\navgCost = " + Util.DoubleMaxString(d) + "\n ---- Position end ----\n";
    }

    public static String positionEnd() {
        return " =============== end ===============";
    }

    public static String accountSummary(int n, String string, String string2, String string3, String string4) {
        return " ---- Account Summary begin ----\nreqId = " + n + "\naccount = " + string + "\ntag = " + string2 + "\nvalue = " + string3 + "\ncurrency = " + string4 + "\n ---- Account Summary end ----\n";
    }

    public static String accountSummaryEnd(int n) {
        return "id=" + n + " =============== end ===============";
    }

    public static String positionMulti(int n, String string, String string2, Contract contract, Decimal decimal, double d) {
        return " ---- Position begin ----\nid = " + n + "\naccount = " + string + "\nmodelCode = " + string2 + "\n" + EWrapperMsgGenerator.contractMsg(contract) + "position = " + decimal + "\navgCost = " + Util.DoubleMaxString(d) + "\n ---- Position end ----\n";
    }

    public static String positionMultiEnd(int n) {
        return "id = " + n + " =============== end ===============";
    }

    public static String accountUpdateMulti(int n, String string, String string2, String string3, String string4, String string5) {
        return " id = " + n + " account = " + string + " modelCode = " + string2 + " key = " + string3 + " value = " + string4 + " currency = " + string5;
    }

    public static String accountUpdateMultiEnd(int n) {
        return "id = " + n + " =============== end ===============";
    }

    public static String securityDefinitionOptionalParameter(int n, String string, int n2, String string2, String string3, Set<String> set, Set<Double> set2) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(" id = ").append(n).append(" exchange = ").append(string).append(" underlyingConId = ").append(n2).append(" tradingClass = ").append(string2).append(" multiplier = ").append(string3).append(" expirations: ");
        for (String object : set) {
            stringBuilder.append(object).append(", ");
        }
        stringBuilder.append(" strikes: ");
        for (Double d : set2) {
            stringBuilder.append(Util.DoubleMaxString(d)).append(", ");
        }
        return stringBuilder.toString();
    }

    public static String securityDefinitionOptionalParameterEnd(int n) {
        return "id = " + n + " =============== end ===============";
    }

    public static String softDollarTiers(int n, SoftDollarTier[] softDollarTierArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== Soft Dollar Tiers Begin (total=").append(softDollarTierArray.length).append(") reqId: ").append(n).append(" ====\n");
        for (int i = 0; i < softDollarTierArray.length; ++i) {
            stringBuilder.append("Soft Dollar Tier [").append(i).append("] - name: ").append(softDollarTierArray[i].name()).append(", value: ").append(softDollarTierArray[i].value()).append("\n");
        }
        stringBuilder.append("==== Soft Dollar Tiers End (total=").append(softDollarTierArray.length).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String familyCodes(FamilyCode[] familyCodeArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("==== Family Codes Begin (total=").append(familyCodeArray.length).append(") ====\n");
        for (int i = 0; i < familyCodeArray.length; ++i) {
            stringBuilder.append("Family Code [").append(i).append("] - accountID: ").append(familyCodeArray[i].accountID()).append(", familyCode: ").append(familyCodeArray[i].familyCodeStr()).append("\n");
        }
        stringBuilder.append("==== Family Codes End (total=").append(familyCodeArray.length).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String symbolSamples(int n, ContractDescription[] contractDescriptionArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("==== Symbol Samples Begin (total=").append(contractDescriptionArray.length).append(") reqId: ").append(n).append(" ====\n");
        for (int i = 0; i < contractDescriptionArray.length; ++i) {
            stringBuilder.append("---- Contract Description Begin (").append(i).append(") ----\n");
            stringBuilder.append("conId: ").append(contractDescriptionArray[i].contract().conid()).append("\n");
            stringBuilder.append("symbol: ").append(contractDescriptionArray[i].contract().symbol()).append("\n");
            stringBuilder.append("secType: ").append(contractDescriptionArray[i].contract().secType()).append("\n");
            stringBuilder.append("primaryExch: ").append(contractDescriptionArray[i].contract().primaryExch()).append("\n");
            stringBuilder.append("currency: ").append(contractDescriptionArray[i].contract().currency()).append("\n");
            stringBuilder.append("derivativeSecTypes (total=").append(contractDescriptionArray[i].derivativeSecTypes().length).append("): ");
            for (int j = 0; j < contractDescriptionArray[i].derivativeSecTypes().length; ++j) {
                stringBuilder.append(contractDescriptionArray[i].derivativeSecTypes()[j]).append(' ');
            }
            stringBuilder.append("\n");
            stringBuilder.append("description: ").append(Util.NormalizeString(contractDescriptionArray[i].contract().description())).append("\n");
            stringBuilder.append("issuerId: ").append(Util.NormalizeString(contractDescriptionArray[i].contract().issuerId())).append("\n");
            stringBuilder.append("---- Contract Description End (").append(i).append(") ----\n");
        }
        stringBuilder.append("==== Symbol Samples End (total=").append(contractDescriptionArray.length).append(") reqId: ").append(n).append(" ====\n");
        return stringBuilder.toString();
    }

    public static String mktDepthExchanges(DepthMktDataDescription[] depthMktDataDescriptionArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== Market Depth Exchanges Begin (total=").append(depthMktDataDescriptionArray.length).append(") ====\n");
        for (int i = 0; i < depthMktDataDescriptionArray.length; ++i) {
            stringBuilder.append("Depth Market Data Description [").append(i).append("] - exchange: ").append(depthMktDataDescriptionArray[i].exchange()).append(", secType: ").append(depthMktDataDescriptionArray[i].secType()).append(", listingExch: ").append(depthMktDataDescriptionArray[i].listingExch()).append(", serviceDataType: ").append(depthMktDataDescriptionArray[i].serviceDataType()).append(", aggGroup: ").append(Util.IntMaxString(depthMktDataDescriptionArray[i].aggGroup())).append("\n");
        }
        stringBuilder.append("==== Market Depth Exchanges End (total=").append(depthMktDataDescriptionArray.length).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String tickNews(int n, long l, String string, String string2, String string3, String string4) {
        return "TickNews. tickerId: " + n + ", timeStamp: " + Util.UnixMillisecondsToString(l, "yyyyMMdd-HH:mm:ss") + ", providerCode: " + string + ", articleId: " + string2 + ", headline: " + string3 + ", extraData: " + string4;
    }

    public static String newsProviders(NewsProvider[] newsProviderArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== News Providers Begin (total=").append(newsProviderArray.length).append(") ====\n");
        for (int i = 0; i < newsProviderArray.length; ++i) {
            stringBuilder.append("News Provider [").append(i).append("] - providerCode: ").append(newsProviderArray[i].providerCode()).append(", providerName: ").append(newsProviderArray[i].providerName()).append("\n");
        }
        stringBuilder.append("==== News Providers End (total=").append(newsProviderArray.length).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String error(Exception exception) {
        return "Error - " + exception;
    }

    public static String error(String string) {
        return string;
    }

    public static String error(int n, int n2, String string, String string2) {
        String string3 = n + " | " + n2 + " | " + string;
        if (string2 != null) {
            string3 = string3 + " | " + string2;
        }
        return string3;
    }

    public static String connectionClosed() {
        return "Connection Closed";
    }

    public static String softDollarTiers(SoftDollarTier[] softDollarTierArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== Soft Dollar Tiers Begin (total=").append(softDollarTierArray.length).append(") ====\n");
        for (SoftDollarTier softDollarTier : softDollarTierArray) {
            stringBuilder.append(softDollarTier).append("\n");
        }
        stringBuilder.append("==== Soft Dollar Tiers End (total=").append(softDollarTierArray.length).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String tickReqParams(int n, double d, String string, int n2) {
        return "id=" + n + " minTick = " + Util.DoubleMaxString(d) + " bboExchange = " + string + " snapshotPermissions = " + Util.IntMaxString(n2);
    }

    public static String smartComponents(int n, Map<Integer, Map.Entry<String, Character>> map) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== Smart Components Begin (total=").append(map.entrySet().size()).append(") reqId = ").append(n).append("====\n");
        for (Map.Entry<Integer, Map.Entry<String, Character>> entry : map.entrySet()) {
            stringBuilder.append("bit number: ").append(entry.getKey()).append(", exchange: ").append(entry.getValue().getKey()).append(", exchange letter: ").append(entry.getValue().getValue()).append("\n");
        }
        stringBuilder.append("==== Smart Components End (total=").append(map.entrySet().size()).append(") reqId = ").append(n).append("====\n");
        return stringBuilder.toString();
    }

    public static String newsArticle(int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== News Article Begin requestId: ").append(n).append(" ====\n");
        if (n2 == 0) {
            stringBuilder.append("---- Article type is text or html ----\n");
            stringBuilder.append(string).append("\n");
        } else if (n2 == 1) {
            stringBuilder.append("---- Article type is binary/pdf ----\n");
            stringBuilder.append("Binary/pdf article text cannot be displayed\n");
        }
        stringBuilder.append("==== News Article End requestId: ").append(n).append(" ====\n");
        return stringBuilder.toString();
    }

    public static String historicalNews(int n, String string, String string2, String string3, String string4) {
        return "Historical News. RequestId: " + n + ", time: " + string + ", providerCode: " + string2 + ", articleId: " + string3 + ", headline: " + string4;
    }

    public static String historicalNewsEnd(int n, boolean bl) {
        return "Historical News End. RequestId: " + n + ", hasMore: " + bl;
    }

    public static String headTimestamp(int n, String string) {
        return "Head timestamp. Req Id: " + n + ", headTimestamp: " + string;
    }

    public static String histogramData(int n, List<HistogramEntry> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Histogram data. Req Id: ").append(n).append(", Data (").append(list.size()).append("):\n");
        list.forEach(histogramEntry -> stringBuilder.append("\tPrice: ").append(Util.DoubleMaxString(histogramEntry.price())).append(", Size: ").append(histogramEntry.size()).append("\n"));
        return stringBuilder.toString();
    }

    public static String rerouteMktDataReq(int n, int n2, String string) {
        return "Re-route market data request. Req Id: " + n + ", Con Id: " + n2 + ", Exchange: " + string;
    }

    public static String rerouteMktDepthReq(int n, int n2, String string) {
        return "Re-route market depth request. Req Id: " + n + ", Con Id: " + n2 + ", Exchange: " + string;
    }

    public static String marketRule(int n, PriceIncrement[] priceIncrementArray) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("==== Market Rule Begin (marketRuleId=").append(n).append(") ====\n");
        for (PriceIncrement priceIncrement : priceIncrementArray) {
            stringBuilder.append("Low Edge: ").append(Util.DoubleMaxString(priceIncrement.lowEdge()));
            stringBuilder.append(", Increment: ").append(Util.DoubleMaxString(priceIncrement.increment()));
            stringBuilder.append("\n");
        }
        stringBuilder.append("==== Market Rule End (marketRuleId=").append(n).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String pnl(int n, double d, double d2, double d3) {
        return "Daily PnL. Req Id: " + n + ", daily PnL: " + Util.DoubleMaxString(d) + ", unrealizedPnL: " + Util.DoubleMaxString(d2) + ", realizedPnL: " + Util.DoubleMaxString(d3);
    }

    public static String pnlSingle(int n, Decimal decimal, double d, double d2, double d3, double d4) {
        return "Daily PnL Single. Req Id: " + n + ", pos: " + decimal + ", daily PnL: " + Util.DoubleMaxString(d) + ", unrealizedPnL: " + Util.DoubleMaxString(d2) + ", realizedPnL: " + Util.DoubleMaxString(d3) + ", value: " + Util.DoubleMaxString(d4);
    }

    public static String historicalTick(int n, long l, double d, Decimal decimal) {
        return "Historical Tick. Req Id: " + n + ", time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + ", price: " + Util.DoubleMaxString(d) + ", size: " + decimal;
    }

    public static String historicalTickBidAsk(int n, long l, TickAttribBidAsk tickAttribBidAsk, double d, double d2, Decimal decimal, Decimal decimal2) {
        return "Historical Tick Bid/Ask. Req Id: " + n + ", time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + ", bid price: " + Util.DoubleMaxString(d) + ", ask price: " + Util.DoubleMaxString(d2) + ", bid size: " + decimal + ", ask size: " + decimal2 + ", tick attribs: " + (tickAttribBidAsk.bidPastLow() ? "bidPastLow " : "") + (tickAttribBidAsk.askPastHigh() ? "askPastHigh " : "");
    }

    public static String historicalTickLast(int n, long l, TickAttribLast tickAttribLast, double d, Decimal decimal, String string, String string2) {
        return "Historical Tick Last. Req Id: " + n + ", time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + ", price: " + Util.DoubleMaxString(d) + ", size: " + decimal + ", exchange: " + string + ", special conditions:" + string2 + ", tick attribs: " + (tickAttribLast.pastLimit() ? "pastLimit " : "") + (tickAttribLast.unreported() ? "unreported " : "");
    }

    public static String tickByTickAllLast(int n, int n2, long l, double d, Decimal decimal, TickAttribLast tickAttribLast, String string, String string2) {
        return (n2 == 1 ? "Last." : "AllLast.") + " Req Id: " + n + " Time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + " Price: " + Util.DoubleMaxString(d) + " Size: " + decimal + " Exch: " + string + " Spec Cond: " + string2 + " Tick Attibs: " + (tickAttribLast.pastLimit() ? "pastLimit " : "") + (n2 == 1 ? "" : (tickAttribLast.unreported() ? "unreported " : ""));
    }

    public static String tickByTickBidAsk(int n, long l, double d, double d2, Decimal decimal, Decimal decimal2, TickAttribBidAsk tickAttribBidAsk) {
        return "BidAsk. Req Id: " + n + " Time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + " BidPrice: " + Util.DoubleMaxString(d) + " AskPrice: " + Util.DoubleMaxString(d2) + " BidSize: " + decimal + " AskSize: " + decimal2 + " Tick Attibs: " + (tickAttribBidAsk.bidPastLow() ? "bidPastLow " : "") + (tickAttribBidAsk.askPastHigh() ? "askPastHigh " : "");
    }

    public static String tickByTickMidPoint(int n, long l, double d) {
        return "MidPoint. Req Id: " + n + " Time: " + Util.UnixSecondsToString(l, "yyyyMMdd-HH:mm:ss") + " MidPoint: " + Util.DoubleMaxString(d);
    }

    public static String orderBound(long l, int n, int n2) {
        return "order bound: apiOrderId=" + Util.IntMaxString(n2) + " apiClientId=" + Util.IntMaxString(n) + " permId=" + Util.LongMaxString(l);
    }

    public static String completedOrder(Contract contract, Order order, OrderState orderState) {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("completed order:");
        EWrapperMsgGenerator.appendOrderFields(stringBuilder, Integer.MAX_VALUE, contract, order, orderState, false);
        return stringBuilder.toString();
    }

    public static String completedOrdersEnd() {
        return "=============== end ===============";
    }

    public static String replaceFAEnd(int n, String string) {
        return "id = " + n + " ===== " + string + " =====";
    }

    public static String wshMetaData(int n, String string) {
        return "wshMetaData. id = " + n + " dataJson= " + string;
    }

    public static String wshEventData(int n, String string) {
        return "wshEventData. id = " + n + " dataJson= " + string;
    }

    public static String historicalSchedule(int n, String string, String string2, String string3, List<HistoricalSession> list) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("==== Historical Schedule Begin (ReqId=").append(n).append(") ====\n");
        stringBuilder.append("Start: ").append(string);
        stringBuilder.append(" End: ").append(string2);
        stringBuilder.append(" Time Zone: ").append(string3);
        stringBuilder.append("\n");
        for (HistoricalSession historicalSession : list) {
            stringBuilder.append("Session: ");
            stringBuilder.append("Start: ").append(historicalSession.startDateTime());
            stringBuilder.append(" End: ").append(historicalSession.endDateTime());
            stringBuilder.append(" Ref Date: ").append(historicalSession.refDate());
            stringBuilder.append("\n");
        }
        stringBuilder.append("==== Historical Schedule End (ReqId=").append(n).append(") ====\n");
        return stringBuilder.toString();
    }

    public static String userInfo(int n, String string) {
        return "UserInfo. Req Id: " + n + " White Branding Id: " + string;
    }

    private static void appendOrderFields(StringBuilder stringBuilder, int n, Contract contract, Order order, OrderState orderState, boolean bl) {
        Util.appendValidIntValue(stringBuilder, "orderId", n);
        Util.appendNonEmptyString(stringBuilder, "action", order.getAction());
        Util.appendNonEmptyString(stringBuilder, "quantity", order.totalQuantity().toString());
        Util.appendPositiveDoubleValue(stringBuilder, "cashQty", order.cashQty());
        Util.appendPositiveIntValue(stringBuilder, "conid", contract.conid());
        Util.appendNonEmptyString(stringBuilder, "symbol", contract.symbol());
        Util.appendNonEmptyString(stringBuilder, "secType", contract.getSecType());
        Util.appendNonEmptyString(stringBuilder, "lastTradeDateOrContractMonth", contract.lastTradeDateOrContractMonth());
        Util.appendPositiveDoubleValue(stringBuilder, "strike", contract.strike());
        Util.appendNonEmptyString(stringBuilder, "right", contract.getRight(), "?");
        Util.appendNonEmptyString(stringBuilder, "multiplier", contract.multiplier());
        Util.appendNonEmptyString(stringBuilder, "exchange", contract.exchange());
        Util.appendNonEmptyString(stringBuilder, "primaryExch", contract.primaryExch());
        Util.appendNonEmptyString(stringBuilder, "currency", contract.currency());
        Util.appendNonEmptyString(stringBuilder, "localSymbol", contract.localSymbol());
        Util.appendNonEmptyString(stringBuilder, "tradingClass", contract.tradingClass());
        Util.appendNonEmptyString(stringBuilder, "type", order.getOrderType());
        Util.appendValidDoubleValue(stringBuilder, "lmtPrice", order.lmtPrice());
        Util.appendValidDoubleValue(stringBuilder, "auxPrice", order.auxPrice());
        Util.appendNonEmptyString(stringBuilder, "TIF", order.getTif());
        Util.appendNonEmptyString(stringBuilder, "openClose", order.openClose());
        Util.appendValidIntValue(stringBuilder, "origin", order.origin());
        Util.appendNonEmptyString(stringBuilder, "orderRef", order.orderRef());
        Util.appendValidIntValue(stringBuilder, "clientId", order.clientId());
        Util.appendValidIntValue(stringBuilder, "parentId", order.parentId());
        Util.appendValidIntValue(stringBuilder, "permId", order.permId());
        Util.appendBooleanFlag(stringBuilder, "outsideRth", order.outsideRth());
        Util.appendBooleanFlag(stringBuilder, "hidden", order.hidden());
        Util.appendValidDoubleValue(stringBuilder, "discretionaryAmt", order.discretionaryAmt());
        Util.appendPositiveIntValue(stringBuilder, "displaySize", order.displaySize());
        Util.appendValidIntValue(stringBuilder, "triggerMethod", order.getTriggerMethod());
        Util.appendNonEmptyString(stringBuilder, "goodAfterTime", order.goodAfterTime());
        Util.appendNonEmptyString(stringBuilder, "goodTillDate", order.goodTillDate());
        Util.appendNonEmptyString(stringBuilder, "faGroup", order.faGroup());
        Util.appendNonEmptyString(stringBuilder, "faMethod", order.getFaMethod());
        Util.appendNonEmptyString(stringBuilder, "faPercentage", order.faPercentage());
        Util.appendPositiveIntValue(stringBuilder, "shortSaleSlot", order.shortSaleSlot());
        if (order.shortSaleSlot() > 0) {
            Util.appendNonEmptyString(stringBuilder, "designatedLocation", order.designatedLocation());
            Util.appendValidIntValue(stringBuilder, "exemptCode", order.exemptCode());
        }
        Util.appendNonEmptyString(stringBuilder, "ocaGroup", order.ocaGroup());
        Util.appendPositiveIntValue(stringBuilder, "ocaType", order.getOcaType());
        Util.appendNonEmptyString(stringBuilder, "rule80A", order.getRule80A());
        Util.appendBooleanFlag(stringBuilder, "blockOrder", order.blockOrder());
        Util.appendBooleanFlag(stringBuilder, "sweepToFill", order.sweepToFill());
        Util.appendBooleanFlag(stringBuilder, "allOrNone", order.allOrNone());
        Util.appendValidIntValue(stringBuilder, "minQty", order.minQty());
        Util.appendValidDoubleValue(stringBuilder, "percentOffset", order.percentOffset());
        Util.appendBooleanFlag(stringBuilder, "optOutSmartRouting", order.optOutSmartRouting());
        Util.appendValidDoubleValue(stringBuilder, "startingPrice", order.startingPrice());
        Util.appendValidDoubleValue(stringBuilder, "stockRefPrice", order.stockRefPrice());
        Util.appendValidDoubleValue(stringBuilder, "delta", order.delta());
        Util.appendValidDoubleValue(stringBuilder, "stockRangeLower", order.stockRangeLower());
        Util.appendValidDoubleValue(stringBuilder, "stockRangeUpper", order.stockRangeUpper());
        Util.appendValidDoubleValue(stringBuilder, "volatility", order.volatility());
        if (order.volatility() != Double.MAX_VALUE) {
            Util.appendPositiveIntValue(stringBuilder, "volatilityType", order.getVolatilityType());
            Util.appendNonEmptyString(stringBuilder, "deltaNeutralOrderType", order.getDeltaNeutralOrderType());
            Util.appendValidDoubleValue(stringBuilder, "deltaNeutralAuxPrice", order.deltaNeutralAuxPrice());
            Util.appendPositiveIntValue(stringBuilder, "deltaNeutralConId", order.deltaNeutralConId());
            Util.appendNonEmptyString(stringBuilder, "deltaNeutralSettlingFirm", order.deltaNeutralSettlingFirm());
            Util.appendNonEmptyString(stringBuilder, "deltaNeutralClearingAccount", order.deltaNeutralClearingAccount());
            Util.appendNonEmptyString(stringBuilder, "deltaNeutralClearingIntent", order.deltaNeutralClearingIntent());
            Util.appendNonEmptyString(stringBuilder, "deltaNeutralOpenClose", order.deltaNeutralOpenClose(), "?");
            Util.appendBooleanFlag(stringBuilder, "deltaNeutralShortSale", order.deltaNeutralShortSale());
            if (order.deltaNeutralShortSale()) {
                Util.appendValidIntValue(stringBuilder, "deltaNeutralShortSaleSlot", order.deltaNeutralShortSaleSlot());
                Util.appendNonEmptyString(stringBuilder, "deltaNeutralDesignatedLocation", order.deltaNeutralDesignatedLocation());
            }
            Util.appendBooleanFlag(stringBuilder, "continuousUpdate", order.continuousUpdate());
            Util.appendValidIntValue(stringBuilder, "referencePriceType", order.getReferencePriceType());
        }
        Util.appendValidDoubleValue(stringBuilder, "trailStopPrice", order.trailStopPrice());
        Util.appendValidDoubleValue(stringBuilder, "trailingPercent", order.trailingPercent());
        Util.appendValidDoubleValue(stringBuilder, "lmtPriceOffset", order.lmtPriceOffset());
        Util.appendValidIntValue(stringBuilder, "scaleInitLevelSize", order.scaleInitLevelSize());
        Util.appendValidIntValue(stringBuilder, "scaleSubsLevelSize", order.scaleSubsLevelSize());
        Util.appendValidDoubleValue(stringBuilder, "scalePriceIncrement", order.scalePriceIncrement());
        Util.appendValidDoubleValue(stringBuilder, "scalePriceAdjustValue", order.scalePriceAdjustValue());
        Util.appendValidIntValue(stringBuilder, "scalePriceAdjustInterval", order.scalePriceAdjustInterval());
        Util.appendValidDoubleValue(stringBuilder, "scaleProfitOffset", order.scaleProfitOffset());
        Util.appendBooleanFlag(stringBuilder, "scaleAutoReset", order.scaleAutoReset());
        Util.appendValidIntValue(stringBuilder, "scaleInitPosition", order.scaleInitPosition());
        Util.appendValidIntValue(stringBuilder, "scaleInitFillQty", order.scaleInitFillQty());
        Util.appendBooleanFlag(stringBuilder, "scaleRandomPercent", order.scaleRandomPercent());
        Util.appendNonEmptyString(stringBuilder, "hedgeType", order.getHedgeType());
        Util.appendNonEmptyString(stringBuilder, "hedgeParam", order.hedgeParam());
        Util.appendNonEmptyString(stringBuilder, "account", order.account());
        Util.appendNonEmptyString(stringBuilder, "modelCode", order.modelCode());
        Util.appendNonEmptyString(stringBuilder, "settlingFirm", order.settlingFirm());
        Util.appendNonEmptyString(stringBuilder, "clearingAccount", order.clearingAccount());
        Util.appendNonEmptyString(stringBuilder, "clearingIntent", order.clearingIntent());
        Util.appendBooleanFlag(stringBuilder, "notHeld", order.notHeld());
        Util.appendBooleanFlag(stringBuilder, "whatIf", order.whatIf());
        Util.appendBooleanFlag(stringBuilder, "solicited", order.solicited());
        Util.appendBooleanFlag(stringBuilder, "randomizeSize", order.randomizeSize());
        Util.appendBooleanFlag(stringBuilder, "randomizePrice", order.randomizePrice());
        Util.appendBooleanFlag(stringBuilder, "dontUseAutoPriceForHedge", order.dontUseAutoPriceForHedge());
        Util.appendBooleanFlag(stringBuilder, "isOmsContainer", order.isOmsContainer());
        Util.appendBooleanFlag(stringBuilder, "discretionaryUpToLimitPrice", order.discretionaryUpToLimitPrice());
        Util.appendBooleanFlag(stringBuilder, "usePriceMgmtAlgo", order.usePriceMgmtAlgo());
        if (Util.IsPegBenchOrder(order.orderType())) {
            Util.appendPositiveIntValue(stringBuilder, "referenceContractId", order.referenceContractId());
            Util.appendBooleanFlag(stringBuilder, "isPeggedChangeAmountDecrease", order.isPeggedChangeAmountDecrease());
            Util.appendValidDoubleValue(stringBuilder, "peggedChangeAmount", order.peggedChangeAmount());
            Util.appendValidDoubleValue(stringBuilder, "referenceChangeAmount", order.referenceChangeAmount());
            Util.appendNonEmptyString(stringBuilder, "referenceExchangeId", order.referenceExchangeId());
        }
        if ("BAG".equals(contract.getSecType())) {
            if (contract.comboLegsDescrip() != null) {
                Util.appendNonEmptyString(stringBuilder, "comboLegsDescrip", contract.comboLegsDescrip());
            }
            stringBuilder.append(" comboLegs={");
            if (contract.comboLegs() != null) {
                for (int i = 0; i < contract.comboLegs().size(); ++i) {
                    ComboLeg object = contract.comboLegs().get(i);
                    stringBuilder.append(" leg ").append(i + 1).append(":");
                    Util.appendPositiveIntValue(stringBuilder, "conid", object.conid());
                    Util.appendPositiveIntValue(stringBuilder, "ratio", object.ratio());
                    Util.appendNonEmptyString(stringBuilder, "action", object.getAction());
                    Util.appendNonEmptyString(stringBuilder, "exchange", object.exchange());
                    Util.appendValidIntValue(stringBuilder, "openClose", object.getOpenClose());
                    Util.appendBooleanFlag(stringBuilder, "shortSaleSlot", object.shortSaleSlot());
                    if (object.shortSaleSlot() > 0) {
                        Util.appendNonEmptyString(stringBuilder, "designatedLocation", object.designatedLocation());
                        Util.appendValidIntValue(stringBuilder, "exemptCode", object.exemptCode());
                    }
                    if (order.orderComboLegs() != null && contract.comboLegs().size() == order.orderComboLegs().size()) {
                        OrderComboLeg orderComboLeg = order.orderComboLegs().get(i);
                        Util.appendValidDoubleValue(stringBuilder, "price", orderComboLeg.price());
                    }
                    stringBuilder.append(';');
                }
            }
            stringBuilder.append('}');
            if (order.basisPoints() != Double.MAX_VALUE) {
                Util.appendValidDoubleValue(stringBuilder, "basisPoints", order.basisPoints());
                Util.appendValidIntValue(stringBuilder, "basisPointsType", order.basisPointsType());
            }
        }
        if (contract.deltaNeutralContract() != null) {
            DeltaNeutralContract deltaNeutralContract = contract.deltaNeutralContract();
            stringBuilder.append(" deltaNeutralContract={");
            Util.appendPositiveIntValue(stringBuilder, "conid", deltaNeutralContract.conid());
            Util.appendValidDoubleValue(stringBuilder, "delta", deltaNeutralContract.delta());
            Util.appendValidDoubleValue(stringBuilder, "price", deltaNeutralContract.price());
            stringBuilder.append("}");
        }
        if (!Util.StringIsEmpty(order.getAlgoStrategy())) {
            Util.appendNonEmptyString(stringBuilder, "algoStrategy", order.getAlgoStrategy());
            if (order.algoParams() != null && order.algoParams().size() > 0) {
                stringBuilder.append(" algoParams={");
                for (TagValue tagValue : order.algoParams()) {
                    stringBuilder.append(tagValue.m_tag).append('=').append(tagValue.m_value).append(',');
                }
                if (!order.algoParams().isEmpty()) {
                    stringBuilder.setLength(stringBuilder.length() - 1);
                }
                stringBuilder.append('}');
            }
        }
        if ("BAG".equals(contract.getSecType()) && order.smartComboRoutingParams() != null && order.smartComboRoutingParams().size() > 0) {
            stringBuilder.append(" smartComboRoutingParams={");
            for (TagValue tagValue : order.smartComboRoutingParams()) {
                stringBuilder.append(tagValue.m_tag).append('=').append(tagValue.m_value).append(',');
            }
            if (!order.smartComboRoutingParams().isEmpty()) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.append('}');
        }
        Util.appendNonEmptyString(stringBuilder, "autoCancelDate", order.autoCancelDate());
        Util.appendNonEmptyString(stringBuilder, "filledQuantity", order.filledQuantity().toString());
        Util.appendPositiveIntValue(stringBuilder, "refFuturesConId", order.refFuturesConId());
        Util.appendBooleanFlag(stringBuilder, "autoCancelParent", order.autoCancelParent());
        Util.appendNonEmptyString(stringBuilder, "shareholder", order.shareholder());
        Util.appendBooleanFlag(stringBuilder, "imbalanceOnly", order.imbalanceOnly());
        Util.appendBooleanFlag(stringBuilder, "routeMarketableToBbo", order.routeMarketableToBbo());
        Util.appendValidLongValue(stringBuilder, "parentPermId", order.parentPermId());
        Util.appendValidIntValue(stringBuilder, "duration", order.duration());
        Util.appendValidIntValue(stringBuilder, "postToAts", order.postToAts());
        Util.appendValidIntValue(stringBuilder, "minTradeQty", order.minTradeQty());
        Util.appendValidIntValue(stringBuilder, "minCompeteSize", order.minCompeteSize());
        if (order.competeAgainstBestOffset() != Double.MAX_VALUE) {
            if (order.isCompeteAgainstBestOffsetUpToMid()) {
                stringBuilder.append(" ").append("competeAgainstBestOffsetUpToMid");
            } else {
                stringBuilder.append(" ").append("competeAgainstBestOffset").append("=").append(order.competeAgainstBestOffset());
            }
        }
        Util.appendValidDoubleValue(stringBuilder, "midOffsetAtWhole", order.midOffsetAtWhole());
        Util.appendValidDoubleValue(stringBuilder, "midOffsetAtHalf", order.midOffsetAtHalf());
        Util.appendNonEmptyString(stringBuilder, "customerAccount", order.customerAccount());
        Util.appendBooleanFlag(stringBuilder, "professionalCustomer", order.professionalCustomer());
        Util.appendNonEmptyString(stringBuilder, "status", orderState.getStatus());
        Util.appendNonEmptyString(stringBuilder, "completedTime", orderState.completedTime());
        Util.appendNonEmptyString(stringBuilder, "completedStatus", orderState.completedStatus());
        if (order.whatIf()) {
            Util.appendValidDoubleValue(stringBuilder, "initMarginBefore", orderState.initMarginBefore());
            Util.appendValidDoubleValue(stringBuilder, "maintMarginBefore", orderState.maintMarginBefore());
            Util.appendValidDoubleValue(stringBuilder, "equityWithLoanBefore", orderState.equityWithLoanBefore());
            Util.appendValidDoubleValue(stringBuilder, "initMarginChange", orderState.initMarginChange());
            Util.appendValidDoubleValue(stringBuilder, "maintMarginChange", orderState.maintMarginChange());
            Util.appendValidDoubleValue(stringBuilder, "equityWithLoanChange", orderState.equityWithLoanChange());
            Util.appendValidDoubleValue(stringBuilder, "initMarginAfter", orderState.initMarginAfter());
            Util.appendValidDoubleValue(stringBuilder, "maintMarginAfter", orderState.maintMarginAfter());
            Util.appendValidDoubleValue(stringBuilder, "equityWithLoanAfter", orderState.equityWithLoanAfter());
            Util.appendValidDoubleValue(stringBuilder, "commission", orderState.commission());
            Util.appendValidDoubleValue(stringBuilder, "minCommission", orderState.minCommission());
            Util.appendValidDoubleValue(stringBuilder, "maxCommission", orderState.maxCommission());
            Util.appendNonEmptyString(stringBuilder, "commissionCurrency", orderState.commissionCurrency());
            Util.appendNonEmptyString(stringBuilder, "warningText", orderState.warningText());
        }
        if (order.conditions() != null && order.conditions().size() > 0) {
            stringBuilder.append(" conditions={");
            for (OrderCondition orderCondition : order.conditions()) {
                stringBuilder.append(orderCondition).append(";");
            }
            if (!order.conditions().isEmpty()) {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
            stringBuilder.append('}');
        }
    }
}

