/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Bar;
import com.ib.client.BitMask;
import com.ib.client.CommissionReport;
import com.ib.client.Contract;
import com.ib.client.ContractDescription;
import com.ib.client.ContractDetails;
import com.ib.client.Decimal;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.DepthMktDataDescription;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EMessage;
import com.ib.client.EOrderDecoder;
import com.ib.client.EWrapper;
import com.ib.client.Execution;
import com.ib.client.FamilyCode;
import com.ib.client.HistogramEntry;
import com.ib.client.HistoricalSession;
import com.ib.client.HistoricalTick;
import com.ib.client.HistoricalTickBidAsk;
import com.ib.client.HistoricalTickLast;
import com.ib.client.NewsProvider;
import com.ib.client.Order;
import com.ib.client.OrderState;
import com.ib.client.PriceIncrement;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.TickAttrib;
import com.ib.client.TickAttribBidAsk;
import com.ib.client.TickAttribLast;
import com.ib.client.TickType;
import com.ib.client.Types;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

class EDecoder
implements ObjectInput {
    private static final int END_CONN = -1;
    private static final int TICK_PRICE = 1;
    private static final int TICK_SIZE = 2;
    private static final int ORDER_STATUS = 3;
    private static final int ERR_MSG = 4;
    private static final int OPEN_ORDER = 5;
    private static final int ACCT_VALUE = 6;
    private static final int PORTFOLIO_VALUE = 7;
    private static final int ACCT_UPDATE_TIME = 8;
    private static final int NEXT_VALID_ID = 9;
    private static final int CONTRACT_DATA = 10;
    private static final int EXECUTION_DATA = 11;
    private static final int MARKET_DEPTH = 12;
    private static final int MARKET_DEPTH_L2 = 13;
    private static final int NEWS_BULLETINS = 14;
    private static final int MANAGED_ACCTS = 15;
    private static final int RECEIVE_FA = 16;
    private static final int HISTORICAL_DATA = 17;
    private static final int BOND_CONTRACT_DATA = 18;
    private static final int SCANNER_PARAMETERS = 19;
    private static final int SCANNER_DATA = 20;
    private static final int TICK_OPTION_COMPUTATION = 21;
    private static final int TICK_GENERIC = 45;
    private static final int TICK_STRING = 46;
    private static final int TICK_EFP = 47;
    private static final int CURRENT_TIME = 49;
    private static final int REAL_TIME_BARS = 50;
    private static final int FUNDAMENTAL_DATA = 51;
    private static final int CONTRACT_DATA_END = 52;
    private static final int OPEN_ORDER_END = 53;
    private static final int ACCT_DOWNLOAD_END = 54;
    private static final int EXECUTION_DATA_END = 55;
    private static final int DELTA_NEUTRAL_VALIDATION = 56;
    private static final int TICK_SNAPSHOT_END = 57;
    private static final int MARKET_DATA_TYPE = 58;
    private static final int COMMISSION_REPORT = 59;
    private static final int POSITION = 61;
    private static final int POSITION_END = 62;
    private static final int ACCOUNT_SUMMARY = 63;
    private static final int ACCOUNT_SUMMARY_END = 64;
    private static final int VERIFY_MESSAGE_API = 65;
    private static final int VERIFY_COMPLETED = 66;
    private static final int DISPLAY_GROUP_LIST = 67;
    private static final int DISPLAY_GROUP_UPDATED = 68;
    private static final int VERIFY_AND_AUTH_MESSAGE_API = 69;
    private static final int VERIFY_AND_AUTH_COMPLETED = 70;
    private static final int POSITION_MULTI = 71;
    private static final int POSITION_MULTI_END = 72;
    private static final int ACCOUNT_UPDATE_MULTI = 73;
    private static final int ACCOUNT_UPDATE_MULTI_END = 74;
    private static final int SECURITY_DEFINITION_OPTION_PARAMETER = 75;
    private static final int SECURITY_DEFINITION_OPTION_PARAMETER_END = 76;
    private static final int SOFT_DOLLAR_TIERS = 77;
    private static final int FAMILY_CODES = 78;
    private static final int SYMBOL_SAMPLES = 79;
    private static final int MKT_DEPTH_EXCHANGES = 80;
    private static final int TICK_REQ_PARAMS = 81;
    private static final int SMART_COMPONENTS = 82;
    private static final int NEWS_ARTICLE = 83;
    private static final int TICK_NEWS = 84;
    private static final int NEWS_PROVIDERS = 85;
    private static final int HISTORICAL_NEWS = 86;
    private static final int HISTORICAL_NEWS_END = 87;
    private static final int HEAD_TIMESTAMP = 88;
    private static final int HISTOGRAM_DATA = 89;
    private static final int HISTORICAL_DATA_UPDATE = 90;
    private static final int REROUTE_MKT_DATA_REQ = 91;
    private static final int REROUTE_MKT_DEPTH_REQ = 92;
    private static final int MARKET_RULE = 93;
    private static final int PNL = 94;
    private static final int PNL_SINGLE = 95;
    private static final int HISTORICAL_TICKS = 96;
    private static final int HISTORICAL_TICKS_BID_ASK = 97;
    private static final int HISTORICAL_TICKS_LAST = 98;
    private static final int TICK_BY_TICK = 99;
    private static final int ORDER_BOUND = 100;
    private static final int COMPLETED_ORDER = 101;
    private static final int COMPLETED_ORDERS_END = 102;
    private static final int REPLACE_FA_END = 103;
    private static final int WSH_META_DATA = 104;
    private static final int WSH_EVENT_DATA = 105;
    private static final int HISTORICAL_SCHEDULE = 106;
    private static final int USER_INFO = 107;
    static final int MAX_MSG_LENGTH = 0xFFFFFF;
    private static final int REDIRECT_MSG_ID = -1;
    private EClientMsgSink m_clientMsgSink;
    private EWrapper m_EWrapper;
    private int m_serverVersion;
    private IMessageReader m_messageReader;

    public EDecoder(int n, EWrapper eWrapper) {
        this(n, eWrapper, null);
    }

    public EDecoder(int n, EWrapper eWrapper, EClientMsgSink eClientMsgSink) {
        this.m_clientMsgSink = eClientMsgSink;
        this.m_serverVersion = n;
        this.m_EWrapper = eWrapper;
    }

    private void processFirstMsg() throws IOException {
        this.m_serverVersion = this.readInt();
        if (this.m_serverVersion == -1) {
            String string = this.readStr();
            this.m_serverVersion = 0;
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.redirect(string);
            }
            return;
        }
        if (this.m_serverVersion >= 20) {
            String string = this.readStr();
            if (this.m_clientMsgSink != null) {
                this.m_clientMsgSink.serverVersion(this.m_serverVersion, string);
            }
        } else if (this.m_clientMsgSink != null) {
            this.m_clientMsgSink.serverVersion(this.m_serverVersion, null);
        }
        this.m_EWrapper.connectAck();
    }

    private boolean readMessageToInternalBuf(InputStream inputStream) {
        this.m_messageReader = new PreV100MessageReader(inputStream);
        return true;
    }

    public int processMsg(EMessage eMessage) throws IOException {
        if (!this.readMessageToInternalBuf(eMessage.getStream())) {
            return 0;
        }
        if (this.m_serverVersion == 0) {
            this.processFirstMsg();
            return this.m_messageReader.msgLength();
        }
        int n = this.readInt();
        switch (n) {
            case -1: {
                return 0;
            }
            case 1: {
                this.processTickPriceMsg();
                break;
            }
            case 2: {
                this.processTickSizeMsg();
                break;
            }
            case 61: {
                this.processPositionMsg();
                break;
            }
            case 62: {
                this.processPositionEndMsg();
                break;
            }
            case 63: {
                this.processAccountSummaryMsg();
                break;
            }
            case 64: {
                this.processAccountSummaryEndMsg();
                break;
            }
            case 21: {
                this.processTickOptionComputationMsg();
                break;
            }
            case 45: {
                this.processTickGenericMsg();
                break;
            }
            case 46: {
                this.processTickStringMsg();
                break;
            }
            case 47: {
                this.processTickEFPMsg();
                break;
            }
            case 3: {
                this.processOrderStatusMsg();
                break;
            }
            case 6: {
                this.processAcctValueMsg();
                break;
            }
            case 7: {
                this.processPortfolioValueMsg();
                break;
            }
            case 8: {
                this.processAcctUpdateTimeMsg();
                break;
            }
            case 4: {
                this.processErrMsgMsg();
                break;
            }
            case 5: {
                this.processOpenOrderMsg();
                break;
            }
            case 9: {
                this.processNextValidIdMsg();
                break;
            }
            case 20: {
                this.processScannerDataMsg();
                break;
            }
            case 10: {
                this.processContractDataMsg();
                break;
            }
            case 18: {
                this.processBondContractDataMsg();
                break;
            }
            case 11: {
                this.processExecutionDataMsg();
                break;
            }
            case 12: {
                this.processMarketDepthMsg();
                break;
            }
            case 13: {
                this.processMarketDepthL2Msg();
                break;
            }
            case 14: {
                this.processNewsBulletinsMsg();
                break;
            }
            case 15: {
                this.processManagedAcctsMsg();
                break;
            }
            case 16: {
                this.processReceiveFaMsg();
                break;
            }
            case 17: {
                this.processHistoricalDataMsg();
                break;
            }
            case 19: {
                this.processScannerParametersMsg();
                break;
            }
            case 49: {
                this.processCurrentTimeMsg();
                break;
            }
            case 50: {
                this.processRealTimeBarsMsg();
                break;
            }
            case 51: {
                this.processFundamentalDataMsg();
                break;
            }
            case 52: {
                this.processContractDataEndMsg();
                break;
            }
            case 53: {
                this.processOpenOrderEndMsg();
                break;
            }
            case 54: {
                this.processAcctDownloadEndMsg();
                break;
            }
            case 55: {
                this.processExecutionDataEndMsg();
                break;
            }
            case 56: {
                this.processDeltaNeutralValidationMsg();
                break;
            }
            case 57: {
                this.processTickSnapshotEndMsg();
                break;
            }
            case 58: {
                this.processMarketDataTypeMsg();
                break;
            }
            case 59: {
                this.processCommissionReportMsg();
                break;
            }
            case 65: {
                this.processVerifyMessageApiMsg();
                break;
            }
            case 66: {
                this.processVerifyCompletedMsg();
                break;
            }
            case 67: {
                this.processDisplayGroupListMsg();
                break;
            }
            case 68: {
                this.processDisplayGroupUpdatedMsg();
                break;
            }
            case 69: {
                this.processVerifyAndAuthMessageMsg();
                break;
            }
            case 70: {
                this.processVerifyAndAuthCompletedMsg();
                break;
            }
            case 71: {
                this.processPositionMultiMsg();
                break;
            }
            case 72: {
                this.processPositionMultiEndMsg();
                break;
            }
            case 73: {
                this.processAccountUpdateMultiMsg();
                break;
            }
            case 74: {
                this.processAccountUpdateMultiEndMsg();
                break;
            }
            case 75: {
                this.processSecurityDefinitionOptionalParameterMsg();
                break;
            }
            case 76: {
                this.processSecurityDefinitionOptionalParameterEndMsg();
                break;
            }
            case 77: {
                this.processSoftDollarTiersMsg();
                break;
            }
            case 78: {
                this.processFamilyCodesMsg();
                break;
            }
            case 82: {
                this.processSmartComponentsMsg();
                break;
            }
            case 81: {
                this.processTickReqParamsMsg();
                break;
            }
            case 79: {
                this.processSymbolSamplesMsg();
                break;
            }
            case 80: {
                this.processMktDepthExchangesMsg();
                break;
            }
            case 88: {
                this.processHeadTimestampMsg();
                break;
            }
            case 84: {
                this.processTickNewsMsg();
                break;
            }
            case 85: {
                this.processNewsProvidersMsg();
                break;
            }
            case 83: {
                this.processNewsArticleMsg();
                break;
            }
            case 86: {
                this.processHistoricalNewsMsg();
                break;
            }
            case 87: {
                this.processHistoricalNewsEndMsg();
                break;
            }
            case 89: {
                this.processHistogramDataMsg();
                break;
            }
            case 90: {
                this.processHistoricalDataUpdateMsg();
                break;
            }
            case 91: {
                this.processRerouteMktDataReq();
                break;
            }
            case 92: {
                this.processRerouteMktDepthReq();
                break;
            }
            case 93: {
                this.processMarketRuleMsg();
                break;
            }
            case 94: {
                this.processPnLMsg();
                break;
            }
            case 95: {
                this.processPnLSingleMsg();
                break;
            }
            case 96: {
                this.processHistoricalTicks();
                break;
            }
            case 97: {
                this.processHistoricalTicksBidAsk();
                break;
            }
            case 98: {
                this.processHistoricalTicksLast();
                break;
            }
            case 99: {
                this.processTickByTickMsg();
                break;
            }
            case 100: {
                this.processOrderBoundMsg();
                break;
            }
            case 101: {
                this.processCompletedOrderMsg();
                break;
            }
            case 102: {
                this.processCompletedOrdersEndMsg();
                break;
            }
            case 103: {
                this.processReplaceFAEndMsg();
                break;
            }
            case 104: {
                this.processWshMetaData();
                break;
            }
            case 105: {
                this.processWshEventData();
                break;
            }
            case 106: {
                this.processHistoricalSchedule();
                break;
            }
            case 107: {
                this.processUserInfo();
                break;
            }
            default: {
                this.m_EWrapper.error(-1, EClientErrors.UNKNOWN_ID.code(), EClientErrors.UNKNOWN_ID.msg(), null);
                return 0;
            }
        }
        this.m_messageReader.close();
        return this.m_messageReader.msgLength();
    }

    private void processHistoricalTicksLast() throws IOException {
        int n;
        int n2 = this.readInt();
        int n3 = this.readInt();
        ArrayList<HistoricalTickLast> arrayList = new ArrayList<HistoricalTickLast>();
        for (n = 0; n < n3; ++n) {
            long l = this.readLong();
            BitMask bitMask = new BitMask(this.readInt());
            TickAttribLast tickAttribLast = new TickAttribLast();
            tickAttribLast.pastLimit(bitMask.get(0));
            tickAttribLast.unreported(bitMask.get(1));
            double d = this.readDouble();
            Decimal decimal = this.readDecimal();
            String string = this.readStr();
            String string2 = this.readStr();
            arrayList.add(new HistoricalTickLast(l, tickAttribLast, d, decimal, string, string2));
        }
        n = this.readBoolean() ? 1 : 0;
        this.m_EWrapper.historicalTicksLast(n2, arrayList, n != 0);
    }

    private void processHistoricalTicksBidAsk() throws IOException {
        int n;
        int n2 = this.readInt();
        int n3 = this.readInt();
        ArrayList<HistoricalTickBidAsk> arrayList = new ArrayList<HistoricalTickBidAsk>();
        for (n = 0; n < n3; ++n) {
            long l = this.readLong();
            BitMask bitMask = new BitMask(this.readInt());
            TickAttribBidAsk tickAttribBidAsk = new TickAttribBidAsk();
            tickAttribBidAsk.askPastHigh(bitMask.get(0));
            tickAttribBidAsk.bidPastLow(bitMask.get(1));
            double d = this.readDouble();
            double d2 = this.readDouble();
            Decimal decimal = this.readDecimal();
            Decimal decimal2 = this.readDecimal();
            arrayList.add(new HistoricalTickBidAsk(l, tickAttribBidAsk, d, d2, decimal, decimal2));
        }
        n = this.readBoolean() ? 1 : 0;
        this.m_EWrapper.historicalTicksBidAsk(n2, arrayList, n != 0);
    }

    private void processHistoricalTicks() throws IOException {
        int n;
        int n2 = this.readInt();
        int n3 = this.readInt();
        ArrayList<HistoricalTick> arrayList = new ArrayList<HistoricalTick>();
        for (n = 0; n < n3; ++n) {
            long l = this.readLong();
            this.readInt();
            double d = this.readDouble();
            Decimal decimal = this.readDecimal();
            arrayList.add(new HistoricalTick(l, d, decimal));
        }
        n = this.readBoolean() ? 1 : 0;
        this.m_EWrapper.historicalTicks(n2, arrayList, n != 0);
    }

    private void processMarketRuleMsg() throws IOException {
        PriceIncrement[] priceIncrementArray;
        int n = this.readInt();
        int n2 = this.readInt();
        if (n2 > 0) {
            priceIncrementArray = new PriceIncrement[n2];
            for (int i = 0; i < n2; ++i) {
                priceIncrementArray[i] = new PriceIncrement(this.readDouble(), this.readDouble());
            }
        } else {
            priceIncrementArray = new PriceIncrement[]{};
        }
        this.m_EWrapper.marketRule(n, priceIncrementArray);
    }

    private void processRerouteMktDepthReq() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.rerouteMktDepthReq(n, n2, string);
    }

    private void processRerouteMktDataReq() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.rerouteMktDataReq(n, n2, string);
    }

    private void processHistoricalDataUpdateMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        double d = this.readDouble();
        double d2 = this.readDouble();
        double d3 = this.readDouble();
        double d4 = this.readDouble();
        Decimal decimal = this.readDecimal();
        Decimal decimal2 = this.readDecimal();
        this.m_EWrapper.historicalDataUpdate(n, new Bar(string, d, d3, d4, d2, decimal2, n2, decimal));
    }

    private void processPnLSingleMsg() throws IOException {
        int n = this.readInt();
        Decimal decimal = this.readDecimal();
        double d = this.readDouble();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        if (this.m_serverVersion >= 129) {
            d2 = this.readDouble();
        }
        if (this.m_serverVersion >= 135) {
            d3 = this.readDouble();
        }
        double d4 = this.readDouble();
        this.m_EWrapper.pnlSingle(n, decimal, d, d2, d3, d4);
    }

    private void processPnLMsg() throws IOException {
        int n = this.readInt();
        double d = this.readDouble();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        if (this.m_serverVersion >= 129) {
            d2 = this.readDouble();
        }
        if (this.m_serverVersion >= 135) {
            d3 = this.readDouble();
        }
        this.m_EWrapper.pnl(n, d, d2, d3);
    }

    private void processHistogramDataMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        ArrayList<HistogramEntry> arrayList = new ArrayList<HistogramEntry>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(new HistogramEntry(this.readDouble(), this.readDecimal()));
        }
        this.m_EWrapper.histogramData(n, arrayList);
    }

    private void processHistoricalNewsEndMsg() throws IOException {
        int n = this.readInt();
        boolean bl = this.readBoolFromInt();
        this.m_EWrapper.historicalNewsEnd(n, bl);
    }

    private void processHistoricalNewsMsg() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        String string4 = this.readStr();
        this.m_EWrapper.historicalNews(n, string, string2, string3, string4);
    }

    private void processNewsArticleMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.newsArticle(n, n2, string);
    }

    private void processNewsProvidersMsg() throws IOException {
        NewsProvider[] newsProviderArray = new NewsProvider[]{};
        int n = this.readInt();
        if (n > 0) {
            newsProviderArray = new NewsProvider[n];
            for (int i = 0; i < n; ++i) {
                newsProviderArray[i] = new NewsProvider(this.readStr(), this.readStr());
            }
        }
        this.m_EWrapper.newsProviders(newsProviderArray);
    }

    private void processTickNewsMsg() throws IOException {
        int n = this.readInt();
        long l = this.readLong();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        String string4 = this.readStr();
        this.m_EWrapper.tickNews(n, l, string, string2, string3, string4);
    }

    private void processHeadTimestampMsg() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.headTimestamp(n, string);
    }

    private void processMktDepthExchangesMsg() throws IOException {
        DepthMktDataDescription[] depthMktDataDescriptionArray = new DepthMktDataDescription[]{};
        int n = this.readInt();
        if (n > 0) {
            depthMktDataDescriptionArray = new DepthMktDataDescription[n];
            for (int i = 0; i < n; ++i) {
                depthMktDataDescriptionArray[i] = this.m_serverVersion >= 120 ? new DepthMktDataDescription(this.readStr(), this.readStr(), this.readStr(), this.readStr(), this.readIntMax()) : new DepthMktDataDescription(this.readStr(), this.readStr(), "", this.readBoolFromInt() ? "Deep2" : "Deep", Integer.MAX_VALUE);
            }
        }
        this.m_EWrapper.mktDepthExchanges(depthMktDataDescriptionArray);
    }

    private void processSymbolSamplesMsg() throws IOException {
        int n = this.readInt();
        ContractDescription[] contractDescriptionArray = new ContractDescription[]{};
        int n2 = this.readInt();
        if (n2 > 0) {
            contractDescriptionArray = new ContractDescription[n2];
            for (int i = 0; i < n2; ++i) {
                ContractDescription contractDescription;
                Contract contract = new Contract();
                contract.conid(this.readInt());
                contract.symbol(this.readStr());
                contract.secType(this.readStr());
                contract.primaryExch(this.readStr());
                contract.currency(this.readStr());
                String[] stringArray = new String[]{};
                int n3 = this.readInt();
                if (n3 > 0) {
                    stringArray = new String[n3];
                    for (int j = 0; j < n3; ++j) {
                        stringArray[j] = this.readStr();
                    }
                }
                if (this.m_serverVersion >= 176) {
                    contract.description(this.readStr());
                    contract.issuerId(this.readStr());
                }
                contractDescriptionArray[i] = contractDescription = new ContractDescription(contract, stringArray);
            }
        }
        this.m_EWrapper.symbolSamples(n, contractDescriptionArray);
    }

    private void processFamilyCodesMsg() throws IOException {
        FamilyCode[] familyCodeArray = new FamilyCode[]{};
        int n = this.readInt();
        if (n > 0) {
            familyCodeArray = new FamilyCode[n];
            for (int i = 0; i < n; ++i) {
                familyCodeArray[i] = new FamilyCode(this.readStr(), this.readStr());
            }
        }
        this.m_EWrapper.familyCodes(familyCodeArray);
    }

    private void processSoftDollarTiersMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        SoftDollarTier[] softDollarTierArray = new SoftDollarTier[n2];
        for (int i = 0; i < n2; ++i) {
            softDollarTierArray[i] = new SoftDollarTier(this.readStr(), this.readStr(), this.readStr());
        }
        this.m_EWrapper.softDollarTiers(n, softDollarTierArray);
    }

    private void processSecurityDefinitionOptionalParameterEndMsg() throws IOException {
        int n = this.readInt();
        this.m_EWrapper.securityDefinitionOptionalParameterEnd(n);
    }

    private void processSecurityDefinitionOptionalParameterMsg() throws IOException {
        int n;
        int n2 = this.readInt();
        String string = this.readStr();
        int n3 = this.readInt();
        String string2 = this.readStr();
        String string3 = this.readStr();
        int n4 = this.readInt();
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<Double> hashSet2 = new HashSet<Double>();
        for (n = 0; n < n4; ++n) {
            hashSet.add(this.readStr());
        }
        n = this.readInt();
        for (int i = 0; i < n; ++i) {
            hashSet2.add(this.readDouble());
        }
        this.m_EWrapper.securityDefinitionOptionalParameter(n2, string, n3, string2, string3, hashSet, hashSet2);
    }

    private void processVerifyAndAuthCompletedMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        boolean bl = "true".equals(string);
        String string2 = this.readStr();
        this.m_EWrapper.verifyAndAuthCompleted(bl, string2);
    }

    private void processVerifyAndAuthMessageMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        this.m_EWrapper.verifyAndAuthMessageAPI(string, string2);
    }

    private void processDisplayGroupUpdatedMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.displayGroupUpdated(n, string);
    }

    private void processDisplayGroupListMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.displayGroupList(n, string);
    }

    private void processVerifyCompletedMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        boolean bl = "true".equals(string);
        String string2 = this.readStr();
        this.m_EWrapper.verifyCompleted(bl, string2);
    }

    private void processVerifyMessageApiMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        this.m_EWrapper.verifyMessageAPI(string);
    }

    private void processCommissionReportMsg() throws IOException {
        this.readInt();
        CommissionReport commissionReport = new CommissionReport();
        commissionReport.execId(this.readStr());
        commissionReport.commission(this.readDouble());
        commissionReport.currency(this.readStr());
        commissionReport.realizedPNL(this.readDouble());
        commissionReport.yield(this.readDouble());
        commissionReport.yieldRedemptionDate(this.readInt());
        this.m_EWrapper.commissionReport(commissionReport);
    }

    private void processMarketDataTypeMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        this.m_EWrapper.marketDataType(n, n2);
    }

    private void processTickSnapshotEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.tickSnapshotEnd(n);
    }

    private void processDeltaNeutralValidationMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        DeltaNeutralContract deltaNeutralContract = new DeltaNeutralContract(this.readInt(), this.readDouble(), this.readDouble());
        this.m_EWrapper.deltaNeutralValidation(n, deltaNeutralContract);
    }

    private void processExecutionDataEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.execDetailsEnd(n);
    }

    private void processAcctDownloadEndMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        this.m_EWrapper.accountDownloadEnd(string);
    }

    private void processOpenOrderEndMsg() throws IOException {
        this.readInt();
        this.m_EWrapper.openOrderEnd();
    }

    private void processContractDataEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.contractDetailsEnd(n);
    }

    private void processFundamentalDataMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.fundamentalData(n, string);
    }

    private void processRealTimeBarsMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        long l = this.readLong();
        double d = this.readDouble();
        double d2 = this.readDouble();
        double d3 = this.readDouble();
        double d4 = this.readDouble();
        Decimal decimal = this.readDecimal();
        Decimal decimal2 = this.readDecimal();
        int n2 = this.readInt();
        this.m_EWrapper.realtimeBar(n, l, d, d2, d3, d4, decimal, decimal2, n2);
    }

    private void processCurrentTimeMsg() throws IOException {
        this.readInt();
        long l = this.readLong();
        this.m_EWrapper.currentTime(l);
    }

    private void processScannerParametersMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        this.m_EWrapper.scannerParameters(string);
    }

    private void processHistoricalDataMsg() throws IOException {
        int n = Integer.MAX_VALUE;
        if (this.m_serverVersion < 124) {
            n = this.readInt();
        }
        int n2 = this.readInt();
        String string = "";
        String string2 = "";
        if (n >= 2) {
            string = this.readStr();
            string2 = this.readStr();
        }
        int n3 = this.readInt();
        for (int i = 0; i < n3; ++i) {
            String string3 = this.readStr();
            double d = this.readDouble();
            double d2 = this.readDouble();
            double d3 = this.readDouble();
            double d4 = this.readDouble();
            Decimal decimal = this.readDecimal();
            Decimal decimal2 = this.readDecimal();
            if (this.m_serverVersion < 124) {
                this.readStr();
            }
            int n4 = -1;
            if (n >= 3) {
                n4 = this.readInt();
            }
            this.m_EWrapper.historicalData(n2, new Bar(string3, d, d2, d3, d4, decimal, n4, decimal2));
        }
        this.m_EWrapper.historicalDataEnd(n2, string, string2);
    }

    private void processReceiveFaMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.receiveFA(n, string);
    }

    private void processManagedAcctsMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        this.m_EWrapper.managedAccounts(string);
    }

    private void processNewsBulletinsMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        this.m_EWrapper.updateNewsBulletin(n, n2, string, string2);
    }

    private void processMarketDepthL2Msg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        int n3 = this.readInt();
        int n4 = this.readInt();
        double d = this.readDouble();
        Decimal decimal = this.readDecimal();
        boolean bl = false;
        if (this.m_serverVersion >= 146) {
            bl = this.readBoolFromInt();
        }
        this.m_EWrapper.updateMktDepthL2(n, n2, string, n3, n4, d, decimal, bl);
    }

    private void processMarketDepthMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        double d = this.readDouble();
        Decimal decimal = this.readDecimal();
        this.m_EWrapper.updateMktDepth(n, n2, n3, n4, d, decimal);
    }

    private void processExecutionDataMsg() throws IOException {
        int n = this.m_serverVersion;
        if (this.m_serverVersion < 136) {
            n = this.readInt();
        }
        int n2 = -1;
        if (n >= 7) {
            n2 = this.readInt();
        }
        int n3 = this.readInt();
        Contract contract = new Contract();
        if (n >= 5) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (n >= 9) {
            contract.multiplier(this.readStr());
        }
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (n >= 10) {
            contract.tradingClass(this.readStr());
        }
        Execution execution = new Execution();
        execution.orderId(n3);
        execution.execId(this.readStr());
        execution.time(this.readStr());
        execution.acctNumber(this.readStr());
        execution.exchange(this.readStr());
        execution.side(this.readStr());
        execution.shares(this.readDecimal());
        execution.price(this.readDouble());
        if (n >= 2) {
            execution.permId(this.readInt());
        }
        if (n >= 3) {
            execution.clientId(this.readInt());
        }
        if (n >= 4) {
            execution.liquidation(this.readInt());
        }
        if (n >= 6) {
            execution.cumQty(this.readDecimal());
            execution.avgPrice(this.readDouble());
        }
        if (n >= 8) {
            execution.orderRef(this.readStr());
        }
        if (n >= 9) {
            execution.evRule(this.readStr());
            execution.evMultiplier(this.readDouble());
        }
        if (this.m_serverVersion >= 103) {
            execution.modelCode(this.readStr());
        }
        if (this.m_serverVersion >= 136) {
            execution.lastLiquidity(this.readInt());
        }
        if (this.m_serverVersion >= 178) {
            execution.pendingPriceRevision(this.readBoolFromInt());
        }
        this.m_EWrapper.execDetails(n2, contract, execution);
    }

    private void processBondContractDataMsg() throws IOException {
        int n;
        int n2 = 6;
        if (this.m_serverVersion < 164) {
            n2 = this.readInt();
        }
        int n3 = -1;
        if (n2 >= 3) {
            n3 = this.readInt();
        }
        ContractDetails contractDetails = new ContractDetails();
        contractDetails.contract().symbol(this.readStr());
        contractDetails.contract().secType(this.readStr());
        contractDetails.cusip(this.readStr());
        contractDetails.coupon(this.readDouble());
        this.readLastTradeDate(contractDetails, true);
        contractDetails.issueDate(this.readStr());
        contractDetails.ratings(this.readStr());
        contractDetails.bondType(this.readStr());
        contractDetails.couponType(this.readStr());
        contractDetails.convertible(this.readBoolFromInt());
        contractDetails.callable(this.readBoolFromInt());
        contractDetails.putable(this.readBoolFromInt());
        contractDetails.descAppend(this.readStr());
        contractDetails.contract().exchange(this.readStr());
        contractDetails.contract().currency(this.readStr());
        contractDetails.marketName(this.readStr());
        contractDetails.contract().tradingClass(this.readStr());
        contractDetails.contract().conid(this.readInt());
        contractDetails.minTick(this.readDouble());
        if (this.m_serverVersion >= 110 && this.m_serverVersion < 164) {
            this.readInt();
        }
        contractDetails.orderTypes(this.readStr());
        contractDetails.validExchanges(this.readStr());
        if (n2 >= 2) {
            contractDetails.nextOptionDate(this.readStr());
            contractDetails.nextOptionType(this.readStr());
            contractDetails.nextOptionPartial(this.readBoolFromInt());
            contractDetails.notes(this.readStr());
        }
        if (n2 >= 4) {
            contractDetails.longName(this.readStr());
        }
        if (n2 >= 6) {
            contractDetails.evRule(this.readStr());
            contractDetails.evMultiplier(this.readDouble());
        }
        if (n2 >= 5 && (n = this.readInt()) > 0) {
            contractDetails.secIdList(new ArrayList<TagValue>(n));
            for (int i = 0; i < n; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contractDetails.secIdList().add(tagValue);
            }
        }
        if (this.m_serverVersion >= 121) {
            contractDetails.aggGroup(this.readInt());
        }
        if (this.m_serverVersion >= 126) {
            contractDetails.marketRuleIds(this.readStr());
        }
        if (this.m_serverVersion >= 164) {
            contractDetails.minSize(this.readDecimal());
            contractDetails.sizeIncrement(this.readDecimal());
            contractDetails.suggestedSizeIncrement(this.readDecimal());
        }
        this.m_EWrapper.bondContractDetails(n3, contractDetails);
    }

    private void processContractDataMsg() throws IOException {
        int n;
        int n2 = 8;
        if (this.m_serverVersion < 164) {
            n2 = this.readInt();
        }
        int n3 = -1;
        if (n2 >= 3) {
            n3 = this.readInt();
        }
        ContractDetails contractDetails = new ContractDetails();
        contractDetails.contract().symbol(this.readStr());
        contractDetails.contract().secType(this.readStr());
        this.readLastTradeDate(contractDetails, false);
        if (this.m_serverVersion >= 182) {
            contractDetails.contract().lastTradeDate(this.readStr());
        }
        contractDetails.contract().strike(this.readDouble());
        contractDetails.contract().right(this.readStr());
        contractDetails.contract().exchange(this.readStr());
        contractDetails.contract().currency(this.readStr());
        contractDetails.contract().localSymbol(this.readStr());
        contractDetails.marketName(this.readStr());
        contractDetails.contract().tradingClass(this.readStr());
        contractDetails.contract().conid(this.readInt());
        contractDetails.minTick(this.readDouble());
        if (this.m_serverVersion >= 110 && this.m_serverVersion < 164) {
            this.readInt();
        }
        contractDetails.contract().multiplier(this.readStr());
        contractDetails.orderTypes(this.readStr());
        contractDetails.validExchanges(this.readStr());
        if (n2 >= 2) {
            contractDetails.priceMagnifier(this.readInt());
        }
        if (n2 >= 4) {
            contractDetails.underConid(this.readInt());
        }
        if (n2 >= 5) {
            contractDetails.longName(this.m_serverVersion >= 153 ? EDecoder.decodeUnicodeEscapedString(this.readStr()) : this.readStr());
            contractDetails.contract().primaryExch(this.readStr());
        }
        if (n2 >= 6) {
            contractDetails.contractMonth(this.readStr());
            contractDetails.industry(this.readStr());
            contractDetails.category(this.readStr());
            contractDetails.subcategory(this.readStr());
            contractDetails.timeZoneId(this.readStr());
            contractDetails.tradingHours(this.readStr());
            contractDetails.liquidHours(this.readStr());
        }
        if (n2 >= 8) {
            contractDetails.evRule(this.readStr());
            contractDetails.evMultiplier(this.readDouble());
        }
        if (n2 >= 7 && (n = this.readInt()) > 0) {
            contractDetails.secIdList(new ArrayList<TagValue>(n));
            for (int i = 0; i < n; ++i) {
                TagValue tagValue = new TagValue();
                tagValue.m_tag = this.readStr();
                tagValue.m_value = this.readStr();
                contractDetails.secIdList().add(tagValue);
            }
        }
        if (this.m_serverVersion >= 121) {
            contractDetails.aggGroup(this.readInt());
        }
        if (this.m_serverVersion >= 122) {
            contractDetails.underSymbol(this.readStr());
            contractDetails.underSecType(this.readStr());
        }
        if (this.m_serverVersion >= 126) {
            contractDetails.marketRuleIds(this.readStr());
        }
        if (this.m_serverVersion >= 134) {
            contractDetails.realExpirationDate(this.readStr());
        }
        if (this.m_serverVersion >= 152) {
            contractDetails.stockType(this.readStr());
        }
        if (this.m_serverVersion >= 163 && this.m_serverVersion < 164) {
            this.readDecimal();
        }
        if (this.m_serverVersion >= 164) {
            contractDetails.minSize(this.readDecimal());
            contractDetails.sizeIncrement(this.readDecimal());
            contractDetails.suggestedSizeIncrement(this.readDecimal());
        }
        if (this.m_serverVersion >= 179 && contractDetails.contract().secType() == Types.SecType.FUND) {
            contractDetails.fundName(this.readStr());
            contractDetails.fundFamily(this.readStr());
            contractDetails.fundType(this.readStr());
            contractDetails.fundFrontLoad(this.readStr());
            contractDetails.fundBackLoad(this.readStr());
            contractDetails.fundBackLoadTimeInterval(this.readStr());
            contractDetails.fundManagementFee(this.readStr());
            contractDetails.fundClosed(this.readBoolFromInt());
            contractDetails.fundClosedForNewInvestors(this.readBoolFromInt());
            contractDetails.fundClosedForNewMoney(this.readBoolFromInt());
            contractDetails.fundNotifyAmount(this.readStr());
            contractDetails.fundMinimumInitialPurchase(this.readStr());
            contractDetails.fundSubsequentMinimumPurchase(this.readStr());
            contractDetails.fundBlueSkyStates(this.readStr());
            contractDetails.fundBlueSkyTerritories(this.readStr());
            contractDetails.fundDistributionPolicyIndicator(Types.FundDistributionPolicyIndicator.get(this.readStr()));
            contractDetails.fundAssetType(Types.FundAssetType.get(this.readStr()));
        }
        this.m_EWrapper.contractDetails(n3, contractDetails);
    }

    private void processScannerDataMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.readInt();
            ContractDetails contractDetails = new ContractDetails();
            if (n >= 3) {
                contractDetails.contract().conid(this.readInt());
            }
            contractDetails.contract().symbol(this.readStr());
            contractDetails.contract().secType(this.readStr());
            contractDetails.contract().lastTradeDateOrContractMonth(this.readStr());
            contractDetails.contract().strike(this.readDouble());
            contractDetails.contract().right(this.readStr());
            contractDetails.contract().exchange(this.readStr());
            contractDetails.contract().currency(this.readStr());
            contractDetails.contract().localSymbol(this.readStr());
            contractDetails.marketName(this.readStr());
            contractDetails.contract().tradingClass(this.readStr());
            String string = this.readStr();
            String string2 = this.readStr();
            String string3 = this.readStr();
            String string4 = null;
            if (n >= 2) {
                string4 = this.readStr();
            }
            this.m_EWrapper.scannerData(n2, n4, contractDetails, string, string2, string3, string4);
        }
        this.m_EWrapper.scannerDataEnd(n2);
    }

    private void processNextValidIdMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.nextValidId(n);
    }

    private void processOpenOrderMsg() throws IOException {
        int n = this.m_serverVersion < 145 ? this.readInt() : this.m_serverVersion;
        Contract contract = new Contract();
        Order order = new Order();
        OrderState orderState = new OrderState();
        EOrderDecoder eOrderDecoder = new EOrderDecoder(this, contract, order, orderState, n, this.m_serverVersion);
        eOrderDecoder.readOrderId();
        eOrderDecoder.readContractFields();
        eOrderDecoder.readAction();
        eOrderDecoder.readTotalQuantity();
        eOrderDecoder.readOrderType();
        eOrderDecoder.readLmtPrice();
        eOrderDecoder.readAuxPrice();
        eOrderDecoder.readTIF();
        eOrderDecoder.readOcaGroup();
        eOrderDecoder.readAccount();
        eOrderDecoder.readOpenClose();
        eOrderDecoder.readOrigin();
        eOrderDecoder.readOrderRef();
        eOrderDecoder.readClientId();
        eOrderDecoder.readPermId();
        eOrderDecoder.readOutsideRth();
        eOrderDecoder.readHidden();
        eOrderDecoder.readDiscretionaryAmount();
        eOrderDecoder.readGoodAfterTime();
        eOrderDecoder.skipSharesAllocation();
        eOrderDecoder.readFAParams();
        eOrderDecoder.readModelCode();
        eOrderDecoder.readGoodTillDate();
        eOrderDecoder.readRule80A();
        eOrderDecoder.readPercentOffset();
        eOrderDecoder.readSettlingFirm();
        eOrderDecoder.readShortSaleParams();
        eOrderDecoder.readAuctionStrategy();
        eOrderDecoder.readBoxOrderParams();
        eOrderDecoder.readPegToStkOrVolOrderParams();
        eOrderDecoder.readDisplaySize();
        eOrderDecoder.readOldStyleOutsideRth();
        eOrderDecoder.readBlockOrder();
        eOrderDecoder.readSweepToFill();
        eOrderDecoder.readAllOrNone();
        eOrderDecoder.readMinQty();
        eOrderDecoder.readOcaType();
        eOrderDecoder.readETradeOnly();
        eOrderDecoder.readFirmQuoteOnly();
        eOrderDecoder.readNbboPriceCap();
        eOrderDecoder.readParentId();
        eOrderDecoder.readTriggerMethod();
        eOrderDecoder.readVolOrderParams(true);
        eOrderDecoder.readTrailParams();
        eOrderDecoder.readBasisPoints();
        eOrderDecoder.readComboLegs();
        eOrderDecoder.readSmartComboRoutingParams();
        eOrderDecoder.readScaleOrderParams();
        eOrderDecoder.readHedgeParams();
        eOrderDecoder.readOptOutSmartRouting();
        eOrderDecoder.readClearingParams();
        eOrderDecoder.readNotHeld();
        eOrderDecoder.readDeltaNeutral();
        eOrderDecoder.readAlgoParams();
        eOrderDecoder.readSolicited();
        eOrderDecoder.readWhatIfInfoAndCommission();
        eOrderDecoder.readVolRandomizeFlags();
        eOrderDecoder.readPegToBenchParams();
        eOrderDecoder.readConditions();
        eOrderDecoder.readAdjustedOrderParams();
        eOrderDecoder.readSoftDollarTier();
        eOrderDecoder.readCashQty();
        eOrderDecoder.readDontUseAutoPriceForHedge();
        eOrderDecoder.readIsOmsContainer();
        eOrderDecoder.readDiscretionaryUpToLimitPrice();
        eOrderDecoder.readUsePriceMgmtAlgo();
        eOrderDecoder.readDuration();
        eOrderDecoder.readPostToAts();
        eOrderDecoder.readAutoCancelParent(162);
        eOrderDecoder.readPegBestPegMidOrderAttributes();
        eOrderDecoder.readCustomerAccount();
        eOrderDecoder.readProfessionalCustomer();
        this.m_EWrapper.openOrder(order.orderId(), contract, order, orderState);
    }

    private void processErrMsgMsg() throws IOException {
        int n = this.readInt();
        if (n < 2) {
            String string = this.readStr();
            this.m_EWrapper.error(string);
        } else {
            int n2 = this.readInt();
            int n3 = this.readInt();
            String string = this.m_serverVersion >= 153 ? EDecoder.decodeUnicodeEscapedString(this.readStr()) : this.readStr();
            String string2 = null;
            if (this.m_serverVersion >= 166) {
                string2 = EDecoder.decodeUnicodeEscapedString(this.readStr());
            }
            this.m_EWrapper.error(n2, n3, string, string2);
        }
    }

    private void processAcctUpdateTimeMsg() throws IOException {
        this.readInt();
        String string = this.readStr();
        this.m_EWrapper.updateAccountTime(string);
    }

    private void processPortfolioValueMsg() throws IOException {
        int n = this.readInt();
        Contract contract = new Contract();
        if (n >= 6) {
            contract.conid(this.readInt());
        }
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        if (n >= 7) {
            contract.multiplier(this.readStr());
            contract.primaryExch(this.readStr());
        }
        contract.currency(this.readStr());
        if (n >= 2) {
            contract.localSymbol(this.readStr());
        }
        if (n >= 8) {
            contract.tradingClass(this.readStr());
        }
        Decimal decimal = this.readDecimal();
        double d = this.readDouble();
        double d2 = this.readDouble();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (n >= 3) {
            d3 = this.readDouble();
            d4 = this.readDouble();
            d5 = this.readDouble();
        }
        String string = null;
        if (n >= 4) {
            string = this.readStr();
        }
        if (n == 6 && this.m_serverVersion == 39) {
            contract.primaryExch(this.readStr());
        }
        this.m_EWrapper.updatePortfolio(contract, decimal, d, d2, d3, d4, d5, string);
    }

    private void processAcctValueMsg() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        String string4 = null;
        if (n >= 2) {
            string4 = this.readStr();
        }
        this.m_EWrapper.updateAccountValue(string, string2, string3, string4);
    }

    private void processOrderStatusMsg() throws IOException {
        int n = this.m_serverVersion >= 131 ? Integer.MAX_VALUE : this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        Decimal decimal = this.readDecimal();
        Decimal decimal2 = this.readDecimal();
        double d = this.readDouble();
        int n3 = 0;
        if (n >= 2) {
            n3 = this.readInt();
        }
        int n4 = 0;
        if (n >= 3) {
            n4 = this.readInt();
        }
        double d2 = 0.0;
        if (n >= 4) {
            d2 = this.readDouble();
        }
        int n5 = 0;
        if (n >= 5) {
            n5 = this.readInt();
        }
        String string2 = null;
        if (n >= 6) {
            string2 = this.readStr();
        }
        double d3 = Double.MAX_VALUE;
        if (this.m_serverVersion >= 131) {
            d3 = this.readDouble();
        }
        this.m_EWrapper.orderStatus(n2, string, decimal, decimal2, d, n3, n4, d2, n5, string2, d3);
    }

    private void processTickEFPMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        double d = this.readDouble();
        String string = this.readStr();
        double d2 = this.readDouble();
        int n3 = this.readInt();
        String string2 = this.readStr();
        double d3 = this.readDouble();
        double d4 = this.readDouble();
        this.m_EWrapper.tickEFP(n, n2, d, string, d2, n3, string2, d3, d4);
    }

    private void processTickStringMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.tickString(n, n2, string);
    }

    private void processTickGenericMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        double d = this.readDouble();
        this.m_EWrapper.tickGeneric(n, n2, d);
    }

    private void processTickOptionComputationMsg() throws IOException {
        double d;
        double d2;
        int n = this.m_serverVersion >= 156 ? Integer.MAX_VALUE : this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = Integer.MAX_VALUE;
        if (this.m_serverVersion >= 156) {
            n4 = this.readInt();
        }
        if (Double.compare(d2 = this.readDouble(), -1.0) == 0) {
            d2 = Double.MAX_VALUE;
        }
        if (Double.compare(d = this.readDouble(), -2.0) == 0) {
            d = Double.MAX_VALUE;
        }
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        double d6 = Double.MAX_VALUE;
        double d7 = Double.MAX_VALUE;
        double d8 = Double.MAX_VALUE;
        if (n >= 6 || n3 == TickType.MODEL_OPTION.index() || n3 == TickType.DELAYED_MODEL_OPTION.index()) {
            d3 = this.readDouble();
            if (Double.compare(d3, -1.0) == 0) {
                d3 = Double.MAX_VALUE;
            }
            if (Double.compare(d4 = this.readDouble(), -1.0) == 0) {
                d4 = Double.MAX_VALUE;
            }
        }
        if (n >= 6) {
            d5 = this.readDouble();
            if (Double.compare(d5, -2.0) == 0) {
                d5 = Double.MAX_VALUE;
            }
            if (Double.compare(d6 = this.readDouble(), -2.0) == 0) {
                d6 = Double.MAX_VALUE;
            }
            if (Double.compare(d7 = this.readDouble(), -2.0) == 0) {
                d7 = Double.MAX_VALUE;
            }
            if (Double.compare(d8 = this.readDouble(), -1.0) == 0) {
                d8 = Double.MAX_VALUE;
            }
        }
        this.m_EWrapper.tickOptionComputation(n2, n3, n4, d2, d, d3, d4, d5, d6, d7, d8);
    }

    private void processAccountSummaryEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.accountSummaryEnd(n);
    }

    private void processAccountSummaryMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        String string4 = this.readStr();
        this.m_EWrapper.accountSummary(n, string, string2, string3, string4);
    }

    private void processPositionEndMsg() throws IOException {
        this.readInt();
        this.m_EWrapper.positionEnd();
    }

    private void processPositionMsg() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        Contract contract = new Contract();
        contract.conid(this.readInt());
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        contract.multiplier(this.readStr());
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        if (n >= 2) {
            contract.tradingClass(this.readStr());
        }
        Decimal decimal = this.readDecimal();
        double d = 0.0;
        if (n >= 3) {
            d = this.readDouble();
        }
        this.m_EWrapper.position(string, contract, decimal, d);
    }

    private void processTickSizeMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        int n2 = this.readInt();
        Decimal decimal = this.readDecimal();
        this.m_EWrapper.tickSize(n, n2, decimal);
    }

    private void processTickPriceMsg() throws IOException {
        int n;
        int n2 = this.readInt();
        int n3 = this.readInt();
        int n4 = this.readInt();
        double d = this.readDouble();
        Decimal decimal = Decimal.INVALID;
        TickAttrib tickAttrib = new TickAttrib();
        if (n2 >= 2) {
            decimal = this.readDecimal();
        }
        if (n2 >= 3) {
            n = this.readInt();
            tickAttrib.canAutoExecute(n == 1);
            if (this.m_serverVersion >= 109) {
                BitMask bitMask = new BitMask(n);
                tickAttrib.canAutoExecute(bitMask.get(0));
                tickAttrib.pastLimit(bitMask.get(1));
                if (this.m_serverVersion >= 132) {
                    tickAttrib.preOpen(bitMask.get(2));
                }
            }
        }
        this.m_EWrapper.tickPrice(n3, n4, d, tickAttrib);
        if (n2 >= 2) {
            switch (n4) {
                case 1: {
                    n = 0;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 4: {
                    n = 5;
                    break;
                }
                case 66: {
                    n = 69;
                    break;
                }
                case 67: {
                    n = 70;
                    break;
                }
                case 68: {
                    n = 71;
                    break;
                }
                default: {
                    n = -1;
                }
            }
            if (n != -1) {
                this.m_EWrapper.tickSize(n3, n, decimal);
            }
        }
    }

    private void processPositionMultiMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        Contract contract = new Contract();
        contract.conid(this.readInt());
        contract.symbol(this.readStr());
        contract.secType(this.readStr());
        contract.lastTradeDateOrContractMonth(this.readStr());
        contract.strike(this.readDouble());
        contract.right(this.readStr());
        contract.multiplier(this.readStr());
        contract.exchange(this.readStr());
        contract.currency(this.readStr());
        contract.localSymbol(this.readStr());
        contract.tradingClass(this.readStr());
        Decimal decimal = this.readDecimal();
        double d = this.readDouble();
        String string2 = this.readStr();
        this.m_EWrapper.positionMulti(n, string, string2, contract, decimal, d);
    }

    private void processPositionMultiEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.positionMultiEnd(n);
    }

    private void processAccountUpdateMultiMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        String string4 = this.readStr();
        String string5 = this.readStr();
        this.m_EWrapper.accountUpdateMulti(n, string, string2, string3, string4, string5);
    }

    private void processAccountUpdateMultiEndMsg() throws IOException {
        this.readInt();
        int n = this.readInt();
        this.m_EWrapper.accountUpdateMultiEnd(n);
    }

    private void processSmartComponentsMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        HashMap<Integer, Map.Entry<String, Character>> hashMap = new HashMap<Integer, Map.Entry<String, Character>>();
        for (int i = 0; i < n2; ++i) {
            int n3 = this.readInt();
            String string = this.readStr();
            char c = this.readChar();
            hashMap.put(n3, new AbstractMap.SimpleEntry<String, Character>(string, Character.valueOf(c)));
        }
        this.m_EWrapper.smartComponents(n, hashMap);
    }

    private void processTickReqParamsMsg() throws IOException {
        int n = this.readInt();
        double d = this.readDouble();
        String string = this.readStr();
        int n2 = this.readInt();
        this.m_EWrapper.tickReqParams(n, d, string, n2);
    }

    private void processTickByTickMsg() throws IOException {
        int n = this.readInt();
        int n2 = this.readInt();
        long l = this.readLong();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: 
            case 2: {
                double d = this.readDouble();
                Decimal decimal = this.readDecimal();
                BitMask bitMask = new BitMask(this.readInt());
                TickAttribLast tickAttribLast = new TickAttribLast();
                tickAttribLast.pastLimit(bitMask.get(0));
                tickAttribLast.unreported(bitMask.get(1));
                String string = this.readStr();
                String string2 = this.readStr();
                this.m_EWrapper.tickByTickAllLast(n, n2, l, d, decimal, tickAttribLast, string, string2);
                break;
            }
            case 3: {
                double d = this.readDouble();
                double d2 = this.readDouble();
                Decimal decimal = this.readDecimal();
                Decimal decimal2 = this.readDecimal();
                BitMask bitMask = new BitMask(this.readInt());
                TickAttribBidAsk tickAttribBidAsk = new TickAttribBidAsk();
                tickAttribBidAsk.bidPastLow(bitMask.get(0));
                tickAttribBidAsk.askPastHigh(bitMask.get(1));
                this.m_EWrapper.tickByTickBidAsk(n, l, d, d2, decimal, decimal2, tickAttribBidAsk);
                break;
            }
            case 4: {
                double d = this.readDouble();
                this.m_EWrapper.tickByTickMidPoint(n, l, d);
            }
        }
    }

    private void processOrderBoundMsg() throws IOException {
        long l = this.readLong();
        int n = this.readInt();
        int n2 = this.readInt();
        this.m_EWrapper.orderBound(l, n, n2);
    }

    private void processCompletedOrderMsg() throws IOException {
        Contract contract = new Contract();
        Order order = new Order();
        OrderState orderState = new OrderState();
        EOrderDecoder eOrderDecoder = new EOrderDecoder(this, contract, order, orderState, Integer.MAX_VALUE, this.m_serverVersion);
        eOrderDecoder.readContractFields();
        eOrderDecoder.readAction();
        eOrderDecoder.readTotalQuantity();
        eOrderDecoder.readOrderType();
        eOrderDecoder.readLmtPrice();
        eOrderDecoder.readAuxPrice();
        eOrderDecoder.readTIF();
        eOrderDecoder.readOcaGroup();
        eOrderDecoder.readAccount();
        eOrderDecoder.readOpenClose();
        eOrderDecoder.readOrigin();
        eOrderDecoder.readOrderRef();
        eOrderDecoder.readPermId();
        eOrderDecoder.readOutsideRth();
        eOrderDecoder.readHidden();
        eOrderDecoder.readDiscretionaryAmount();
        eOrderDecoder.readGoodAfterTime();
        eOrderDecoder.readFAParams();
        eOrderDecoder.readModelCode();
        eOrderDecoder.readGoodTillDate();
        eOrderDecoder.readRule80A();
        eOrderDecoder.readPercentOffset();
        eOrderDecoder.readSettlingFirm();
        eOrderDecoder.readShortSaleParams();
        eOrderDecoder.readBoxOrderParams();
        eOrderDecoder.readPegToStkOrVolOrderParams();
        eOrderDecoder.readDisplaySize();
        eOrderDecoder.readSweepToFill();
        eOrderDecoder.readAllOrNone();
        eOrderDecoder.readMinQty();
        eOrderDecoder.readOcaType();
        eOrderDecoder.readTriggerMethod();
        eOrderDecoder.readVolOrderParams(false);
        eOrderDecoder.readTrailParams();
        eOrderDecoder.readComboLegs();
        eOrderDecoder.readSmartComboRoutingParams();
        eOrderDecoder.readScaleOrderParams();
        eOrderDecoder.readHedgeParams();
        eOrderDecoder.readClearingParams();
        eOrderDecoder.readNotHeld();
        eOrderDecoder.readDeltaNeutral();
        eOrderDecoder.readAlgoParams();
        eOrderDecoder.readSolicited();
        eOrderDecoder.readOrderStatus();
        eOrderDecoder.readVolRandomizeFlags();
        eOrderDecoder.readPegToBenchParams();
        eOrderDecoder.readConditions();
        eOrderDecoder.readStopPriceAndLmtPriceOffset();
        eOrderDecoder.readCashQty();
        eOrderDecoder.readDontUseAutoPriceForHedge();
        eOrderDecoder.readIsOmsContainer();
        eOrderDecoder.readAutoCancelDate();
        eOrderDecoder.readFilledQuantity();
        eOrderDecoder.readRefFuturesConId();
        eOrderDecoder.readAutoCancelParent();
        eOrderDecoder.readShareholder();
        eOrderDecoder.readImbalanceOnly();
        eOrderDecoder.readRouteMarketableToBbo();
        eOrderDecoder.readParentPermId();
        eOrderDecoder.readCompletedTime();
        eOrderDecoder.readCompletedStatus();
        eOrderDecoder.readPegBestPegMidOrderAttributes();
        eOrderDecoder.readCustomerAccount();
        eOrderDecoder.readProfessionalCustomer();
        this.m_EWrapper.completedOrder(contract, order, orderState);
    }

    private void processCompletedOrdersEndMsg() throws IOException {
        this.m_EWrapper.completedOrdersEnd();
    }

    private void processReplaceFAEndMsg() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.replaceFAEnd(n, string);
    }

    private void processWshMetaData() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.wshMetaData(n, string);
    }

    private void processWshEventData() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.wshEventData(n, string);
    }

    private void processHistoricalSchedule() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        String string2 = this.readStr();
        String string3 = this.readStr();
        int n2 = this.readInt();
        ArrayList<HistoricalSession> arrayList = new ArrayList<HistoricalSession>();
        for (int i = 0; i < n2; ++i) {
            String string4 = this.readStr();
            String string5 = this.readStr();
            String string6 = this.readStr();
            arrayList.add(new HistoricalSession(string4, string5, string6));
        }
        this.m_EWrapper.historicalSchedule(n, string, string2, string3, arrayList);
    }

    private void processUserInfo() throws IOException {
        int n = this.readInt();
        String string = this.readStr();
        this.m_EWrapper.userInfo(n, string);
    }

    private void readLastTradeDate(ContractDetails contractDetails, boolean bl) throws IOException {
        String string = this.readStr();
        if (string != null) {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.contains("-") ? string.split("-") : string.split("\\s+");
            if (stringArray.length > 0) {
                if (bl) {
                    contractDetails.maturity(stringArray[0]);
                } else {
                    contractDetails.contract().lastTradeDateOrContractMonth(stringArray[0]);
                }
            }
            if (stringArray.length > 1) {
                contractDetails.lastTradeTime(stringArray[1]);
            }
            if (bl && stringArray.length > 2) {
                contractDetails.timeZoneId(stringArray[2]);
            }
        }
    }

    public String readStr() throws IOException {
        return this.m_messageReader.readStr();
    }

    public boolean readBoolFromInt() throws IOException {
        String string = this.readStr();
        return string != null && Integer.parseInt(string) != 0;
    }

    @Override
    public int readInt() throws IOException {
        String string = this.readStr();
        return string == null ? 0 : Integer.parseInt(string);
    }

    public int readIntMax() throws IOException {
        String string = this.readStr();
        return string == null || string.length() == 0 ? Integer.MAX_VALUE : Integer.parseInt(string);
    }

    @Override
    public long readLong() throws IOException {
        String string = this.readStr();
        return string == null ? 0L : Long.parseLong(string);
    }

    @Override
    public double readDouble() throws IOException {
        String string = this.readStr();
        return string == null ? 0.0 : Double.parseDouble(string);
    }

    public double readDoubleMax() throws IOException {
        String string = this.readStr();
        return string == null || string.length() == 0 ? Double.MAX_VALUE : Double.parseDouble(string);
    }

    public Decimal readDecimal() throws IOException {
        String string = this.readStr();
        return string == null || string.isEmpty() || string.equals(String.valueOf(Long.MAX_VALUE)) || string.equals(String.valueOf(Integer.MAX_VALUE)) || string.equals(String.valueOf(Double.MAX_VALUE)) ? Decimal.INVALID : Decimal.parse(string);
    }

    static String decodeUnicodeEscapedString(String string) {
        if (string == null) {
            return string;
        }
        String string2 = new String(string);
        try {
            int n;
            while ((n = string2.indexOf("\\u")) != -1 && string2.length() - n >= 6) {
                String string3 = string2.substring(n, n + 6);
                int n2 = Integer.parseInt(string3.replace("\\u", ""), 16);
                string2 = string2.replace(string3, "" + (char)n2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return string2;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        return this.readStr();
    }

    @Override
    public short readShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() throws IOException {
        return this.readStr();
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char readChar() throws IOException {
        return this.readStr().charAt(0);
    }

    @Override
    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readBoolFromInt();
    }

    @Override
    public long skip(long l) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.m_messageReader.close();
    }

    @Override
    public int available() throws IOException {
        throw new UnsupportedOperationException();
    }

    private static class PreV100MessageReader
    implements IMessageReader {
        private final InputStream m_din;
        private int m_msgLength = 0;

        PreV100MessageReader(InputStream inputStream) {
            this.m_din = inputStream;
        }

        @Override
        public int msgLength() {
            return this.m_msgLength;
        }

        @Override
        public String readStr() throws IOException {
            StringBuilder stringBuilder = new StringBuilder();
            while (true) {
                int n;
                if ((n = this.m_din.read()) <= 0) {
                    if (n < 0) {
                        throw new EOFException();
                    }
                    ++this.m_msgLength;
                    break;
                }
                stringBuilder.append((char)n);
                ++this.m_msgLength;
            }
            String string = stringBuilder.toString();
            return string.length() == 0 ? null : string;
        }

        @Override
        public void close() {
        }
    }

    private static interface IMessageReader
    extends Closeable {
        public String readStr() throws IOException;

        public int msgLength();
    }
}

