/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.EClient;
import com.ib.client.EClientErrors;
import com.ib.client.EClientMsgSink;
import com.ib.client.EMessage;
import com.ib.client.EReader;
import com.ib.client.EReaderSignal;
import com.ib.client.ESocket;
import com.ib.client.EWrapper;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.Socket;

public class EClientSocket
extends EClient
implements EClientMsgSink {
    protected int m_redirectCount = 0;
    protected int m_defaultPort;
    private boolean m_allowRedirect;
    protected DataInputStream m_dis;
    private boolean m_asyncEConnect = false;
    private boolean m_connected = false;
    private Socket m_socket;

    public void setAsyncEConnect(boolean bl) {
        this.m_asyncEConnect = bl;
    }

    public boolean isAsyncEConnect() {
        return this.m_asyncEConnect;
    }

    public EClientSocket(EWrapper eWrapper, EReaderSignal eReaderSignal) {
        super(eWrapper, eReaderSignal);
    }

    @Override
    protected Builder prepareBuffer() {
        Builder builder = new Builder(1024);
        if (this.m_useV100Plus) {
            builder.allocateLengthHeader();
        }
        return builder;
    }

    @Override
    protected void closeAndSend(Builder builder) throws IOException {
        if (this.m_useV100Plus) {
            builder.updateLength(0);
        }
        EMessage eMessage = new EMessage(builder);
        this.sendMsg(eMessage);
    }

    protected synchronized void eConnect(Socket socket) throws IOException {
        this.m_socketTransport = new ESocket(socket);
        this.m_dis = new DataInputStream(socket.getInputStream());
        this.m_defaultPort = socket.getPort();
        this.m_socket = socket;
        this.sendConnectRequest();
        EReader eReader = new EReader(this, this.m_signal);
        if (!this.m_asyncEConnect) {
            if (!eReader.putMessageToQueue()) {
                return;
            }
            while (this.m_serverVersion == 0) {
                this.m_signal.waitForSignal();
                eReader.processMsgs();
            }
        }
    }

    public synchronized void eConnect(Socket socket, int n) throws IOException {
        this.m_clientId = n;
        this.m_redirectCount = 0;
        this.eConnect(socket);
    }

    public synchronized void eConnect(String string, int n, int n2) {
        this.eConnect(string, n, n2, false);
    }

    public synchronized void eConnect(String string, int n, int n2, boolean bl) {
        this.m_host = this.checkConnected(string);
        this.m_clientId = n2;
        this.m_extraAuth = bl;
        this.m_redirectCount = 0;
        if (this.m_host == null) {
            return;
        }
        try {
            Socket socket = new Socket(this.m_host, n);
            this.eConnect(socket);
        }
        catch (Exception exception) {
            this.eDisconnect();
            this.connectionError();
        }
    }

    public boolean allowRedirect() {
        return this.m_allowRedirect;
    }

    public void allowRedirect(boolean bl) {
        this.m_allowRedirect = bl;
    }

    @Override
    public synchronized void redirect(String string) {
        if (this.m_useV100Plus) {
            if (!this.m_allowRedirect) {
                this.m_eWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg(), null);
                return;
            }
            ++this.m_redirectCount;
            if (this.m_redirectCount > 2) {
                this.eDisconnect();
                this.m_eWrapper.error("Redirect count exceeded");
                return;
            }
            this.eDisconnect(false);
            try {
                this.performRedirect(string, this.m_defaultPort);
            }
            catch (IOException iOException) {
                this.m_eWrapper.error(iOException);
            }
        }
    }

    @Override
    public synchronized void serverVersion(int n, String string) {
        this.m_serverVersion = n;
        this.m_TwsTime = string;
        if (this.m_useV100Plus && (this.m_serverVersion < 100 || this.m_serverVersion > 184)) {
            this.eDisconnect();
            this.m_eWrapper.error(-1, EClientErrors.UNSUPPORTED_VERSION.code(), EClientErrors.UNSUPPORTED_VERSION.msg(), null);
            return;
        }
        if (this.m_serverVersion < 38) {
            this.eDisconnect();
            this.m_eWrapper.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg(), null);
            return;
        }
        if (this.m_serverVersion < 70) {
            try {
                this.send(this.m_clientId);
            }
            catch (IOException iOException) {
                this.m_eWrapper.error(iOException);
            }
        }
        this.m_connected = true;
        if (!this.m_asyncEConnect) {
            this.startAPI();
        }
    }

    protected synchronized void performRedirect(String string, int n) throws IOException {
        int n2;
        System.out.println("Server Redirect: " + string);
        String[] stringArray = string.split(":");
        this.m_host = stringArray[0];
        try {
            n2 = stringArray.length > 1 ? Integer.parseInt(stringArray[1]) : n;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Warning: redirect port is invalid, using default port");
            n2 = n;
        }
        this.eConnect(new Socket(this.m_host, n2));
    }

    @Override
    public synchronized void eDisconnect() {
        this.eDisconnect(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void eDisconnect(boolean bl) {
        if (this.m_dis == null && this.m_socketTransport == null) {
            return;
        }
        if (bl) {
            this.m_connected = false;
            this.m_extraAuth = false;
            this.m_clientId = -1;
            this.m_serverVersion = 0;
            this.m_TwsTime = "";
            this.m_redirectCount = 0;
        }
        DataInputStream dataInputStream = this.m_dis;
        this.m_dis = null;
        if (this.m_socketTransport != null) {
            try {
                this.m_socketTransport.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.m_socketTransport = null;
            }
        }
        try {
            if (dataInputStream != null) {
                dataInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_eWrapper.connectionClosed();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.m_dis.read(byArray, n, n2);
    }

    public int readInt() throws IOException {
        return this.m_dis.readInt();
    }

    @Override
    public synchronized boolean isConnected() {
        return this.m_socket != null && this.m_socket.isConnected() && this.m_connected;
    }
}

