/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Builder;
import com.ib.client.ComboLeg;
import com.ib.client.Contract;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.EClientErrors;
import com.ib.client.EClientException;
import com.ib.client.EMessage;
import com.ib.client.EReaderSignal;
import com.ib.client.ETransport;
import com.ib.client.EWrapper;
import com.ib.client.ExecutionFilter;
import com.ib.client.Order;
import com.ib.client.OrderComboLeg;
import com.ib.client.OrderCondition;
import com.ib.client.ScannerSubscription;
import com.ib.client.SoftDollarTier;
import com.ib.client.TagValue;
import com.ib.client.Types;
import com.ib.client.Util;
import com.ib.client.WshEventData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;

public abstract class EClient {
    protected static final int REDIRECT_COUNT_MAX = 2;
    protected static final int CLIENT_VERSION = 66;
    protected static final int MIN_SERVER_VER_SUPPORTED = 38;
    private static final int REQ_MKT_DATA = 1;
    private static final int CANCEL_MKT_DATA = 2;
    protected static final int PLACE_ORDER = 3;
    private static final int CANCEL_ORDER = 4;
    private static final int REQ_OPEN_ORDERS = 5;
    private static final int REQ_ACCOUNT_DATA = 6;
    private static final int REQ_EXECUTIONS = 7;
    private static final int REQ_IDS = 8;
    private static final int REQ_CONTRACT_DATA = 9;
    private static final int REQ_MKT_DEPTH = 10;
    private static final int CANCEL_MKT_DEPTH = 11;
    private static final int REQ_NEWS_BULLETINS = 12;
    private static final int CANCEL_NEWS_BULLETINS = 13;
    private static final int SET_SERVER_LOGLEVEL = 14;
    private static final int REQ_AUTO_OPEN_ORDERS = 15;
    private static final int REQ_ALL_OPEN_ORDERS = 16;
    private static final int REQ_MANAGED_ACCTS = 17;
    private static final int REQ_FA = 18;
    private static final int REPLACE_FA = 19;
    private static final int REQ_HISTORICAL_DATA = 20;
    private static final int EXERCISE_OPTIONS = 21;
    private static final int REQ_SCANNER_SUBSCRIPTION = 22;
    private static final int CANCEL_SCANNER_SUBSCRIPTION = 23;
    private static final int REQ_SCANNER_PARAMETERS = 24;
    private static final int CANCEL_HISTORICAL_DATA = 25;
    private static final int REQ_CURRENT_TIME = 49;
    private static final int REQ_REAL_TIME_BARS = 50;
    private static final int CANCEL_REAL_TIME_BARS = 51;
    private static final int REQ_FUNDAMENTAL_DATA = 52;
    private static final int CANCEL_FUNDAMENTAL_DATA = 53;
    private static final int REQ_CALC_IMPLIED_VOLAT = 54;
    private static final int REQ_CALC_OPTION_PRICE = 55;
    private static final int CANCEL_CALC_IMPLIED_VOLAT = 56;
    private static final int CANCEL_CALC_OPTION_PRICE = 57;
    private static final int REQ_GLOBAL_CANCEL = 58;
    private static final int REQ_MARKET_DATA_TYPE = 59;
    private static final int REQ_POSITIONS = 61;
    private static final int REQ_ACCOUNT_SUMMARY = 62;
    private static final int CANCEL_ACCOUNT_SUMMARY = 63;
    private static final int CANCEL_POSITIONS = 64;
    private static final int VERIFY_REQUEST = 65;
    private static final int VERIFY_MESSAGE = 66;
    private static final int QUERY_DISPLAY_GROUPS = 67;
    private static final int SUBSCRIBE_TO_GROUP_EVENTS = 68;
    private static final int UPDATE_DISPLAY_GROUP = 69;
    private static final int UNSUBSCRIBE_FROM_GROUP_EVENTS = 70;
    private static final int START_API = 71;
    private static final int VERIFY_AND_AUTH_REQUEST = 72;
    private static final int VERIFY_AND_AUTH_MESSAGE = 73;
    private static final int REQ_POSITIONS_MULTI = 74;
    private static final int CANCEL_POSITIONS_MULTI = 75;
    private static final int REQ_ACCOUNT_UPDATES_MULTI = 76;
    private static final int CANCEL_ACCOUNT_UPDATES_MULTI = 77;
    private static final int REQ_SEC_DEF_OPT_PARAMS = 78;
    private static final int REQ_SOFT_DOLLAR_TIERS = 79;
    private static final int REQ_FAMILY_CODES = 80;
    private static final int REQ_MATCHING_SYMBOLS = 81;
    private static final int REQ_MKT_DEPTH_EXCHANGES = 82;
    private static final int REQ_SMART_COMPONENTS = 83;
    private static final int REQ_NEWS_ARTICLE = 84;
    private static final int REQ_NEWS_PROVIDERS = 85;
    private static final int REQ_HISTORICAL_NEWS = 86;
    private static final int REQ_HEAD_TIMESTAMP = 87;
    private static final int REQ_HISTOGRAM_DATA = 88;
    private static final int CANCEL_HISTOGRAM_DATA = 89;
    private static final int CANCEL_HEAD_TIMESTAMP = 90;
    private static final int REQ_MARKET_RULE = 91;
    private static final int REQ_PNL = 92;
    private static final int CANCEL_PNL = 93;
    private static final int REQ_PNL_SINGLE = 94;
    private static final int CANCEL_PNL_SINGLE = 95;
    private static final int REQ_HISTORICAL_TICKS = 96;
    private static final int REQ_TICK_BY_TICK_DATA = 97;
    private static final int CANCEL_TICK_BY_TICK_DATA = 98;
    private static final int REQ_COMPLETED_ORDERS = 99;
    private static final int REQ_WSH_META_DATA = 100;
    private static final int CANCEL_WSH_META_DATA = 101;
    private static final int REQ_WSH_EVENT_DATA = 102;
    private static final int CANCEL_WSH_EVENT_DATA = 103;
    private static final int REQ_USER_INFO = 104;
    private static final int MIN_SERVER_VER_REAL_TIME_BARS = 34;
    private static final int MIN_SERVER_VER_SCALE_ORDERS = 35;
    private static final int MIN_SERVER_VER_SNAPSHOT_MKT_DATA = 35;
    private static final int MIN_SERVER_VER_SSHORT_COMBO_LEGS = 35;
    private static final int MIN_SERVER_VER_WHAT_IF_ORDERS = 36;
    private static final int MIN_SERVER_VER_CONTRACT_CONID = 37;
    private static final int MIN_SERVER_VER_PTA_ORDERS = 39;
    private static final int MIN_SERVER_VER_FUNDAMENTAL_DATA = 40;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL = 40;
    private static final int MIN_SERVER_VER_CONTRACT_DATA_CHAIN = 40;
    private static final int MIN_SERVER_VER_SCALE_ORDERS2 = 40;
    private static final int MIN_SERVER_VER_ALGO_ORDERS = 41;
    private static final int MIN_SERVER_VER_EXECUTION_DATA_CHAIN = 42;
    private static final int MIN_SERVER_VER_NOT_HELD = 44;
    private static final int MIN_SERVER_VER_SEC_ID_TYPE = 45;
    private static final int MIN_SERVER_VER_PLACE_ORDER_CONID = 46;
    private static final int MIN_SERVER_VER_REQ_MKT_DATA_CONID = 47;
    private static final int MIN_SERVER_VER_REQ_CALC_IMPLIED_VOLAT = 49;
    private static final int MIN_SERVER_VER_REQ_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_IMPLIED_VOLAT = 50;
    private static final int MIN_SERVER_VER_CANCEL_CALC_OPTION_PRICE = 50;
    private static final int MIN_SERVER_VER_SSHORTX_OLD = 51;
    private static final int MIN_SERVER_VER_SSHORTX = 52;
    private static final int MIN_SERVER_VER_REQ_GLOBAL_CANCEL = 53;
    private static final int MIN_SERVER_VER_HEDGE_ORDERS = 54;
    private static final int MIN_SERVER_VER_REQ_MARKET_DATA_TYPE = 55;
    private static final int MIN_SERVER_VER_OPT_OUT_SMART_ROUTING = 56;
    private static final int MIN_SERVER_VER_SMART_COMBO_ROUTING_PARAMS = 57;
    private static final int MIN_SERVER_VER_DELTA_NEUTRAL_CONID = 58;
    private static final int MIN_SERVER_VER_SCALE_ORDERS3 = 60;
    private static final int MIN_SERVER_VER_ORDER_COMBO_LEGS_PRICE = 61;
    private static final int MIN_SERVER_VER_TRAILING_PERCENT = 62;
    protected static final int MIN_SERVER_VER_DELTA_NEUTRAL_OPEN_CLOSE = 66;
    private static final int MIN_SERVER_VER_ACCT_SUMMARY = 67;
    protected static final int MIN_SERVER_VER_TRADING_CLASS = 68;
    protected static final int MIN_SERVER_VER_SCALE_TABLE = 69;
    protected static final int MIN_SERVER_VER_LINKING = 70;
    protected static final int MIN_SERVER_VER_ALGO_ID = 71;
    protected static final int MIN_SERVER_VER_OPTIONAL_CAPABILITIES = 72;
    protected static final int MIN_SERVER_VER_ORDER_SOLICITED = 73;
    protected static final int MIN_SERVER_VER_LINKING_AUTH = 74;
    protected static final int MIN_SERVER_VER_PRIMARYEXCH = 75;
    protected static final int MIN_SERVER_VER_RANDOMIZE_SIZE_AND_PRICE = 76;
    protected static final int MIN_SERVER_VER_FRACTIONAL_POSITIONS = 101;
    protected static final int MIN_SERVER_VER_PEGGED_TO_BENCHMARK = 102;
    protected static final int MIN_SERVER_VER_MODELS_SUPPORT = 103;
    protected static final int MIN_SERVER_VER_SEC_DEF_OPT_PARAMS_REQ = 104;
    protected static final int MIN_SERVER_VER_EXT_OPERATOR = 105;
    protected static final int MIN_SERVER_VER_SOFT_DOLLAR_TIER = 106;
    protected static final int MIN_SERVER_VER_REQ_FAMILY_CODES = 107;
    protected static final int MIN_SERVER_VER_REQ_MATCHING_SYMBOLS = 108;
    protected static final int MIN_SERVER_VER_PAST_LIMIT = 109;
    protected static final int MIN_SERVER_VER_MD_SIZE_MULTIPLIER = 110;
    protected static final int MIN_SERVER_VER_CASH_QTY = 111;
    protected static final int MIN_SERVER_VER_REQ_MKT_DEPTH_EXCHANGES = 112;
    protected static final int MIN_SERVER_VER_TICK_NEWS = 113;
    protected static final int MIN_SERVER_VER_REQ_SMART_COMPONENTS = 114;
    protected static final int MIN_SERVER_VER_REQ_NEWS_PROVIDERS = 115;
    protected static final int MIN_SERVER_VER_REQ_NEWS_ARTICLE = 116;
    protected static final int MIN_SERVER_VER_REQ_HISTORICAL_NEWS = 117;
    protected static final int MIN_SERVER_VER_REQ_HEAD_TIMESTAMP = 118;
    protected static final int MIN_SERVER_VER_REQ_HISTOGRAM = 119;
    protected static final int MIN_SERVER_VER_SERVICE_DATA_TYPE = 120;
    protected static final int MIN_SERVER_VER_AGG_GROUP = 121;
    protected static final int MIN_SERVER_VER_UNDERLYING_INFO = 122;
    protected static final int MIN_SERVER_VER_CANCEL_HEADTIMESTAMP = 123;
    protected static final int MIN_SERVER_VER_SYNT_REALTIME_BARS = 124;
    protected static final int MIN_SERVER_VER_CFD_REROUTE = 125;
    protected static final int MIN_SERVER_VER_MARKET_RULES = 126;
    protected static final int MIN_SERVER_VER_PNL = 127;
    protected static final int MIN_SERVER_VER_NEWS_QUERY_ORIGINS = 128;
    protected static final int MIN_SERVER_VER_UNREALIZED_PNL = 129;
    protected static final int MIN_SERVER_VER_HISTORICAL_TICKS = 130;
    protected static final int MIN_SERVER_VER_MARKET_CAP_PRICE = 131;
    protected static final int MIN_SERVER_VER_PRE_OPEN_BID_ASK = 132;
    protected static final int MIN_SERVER_VER_REAL_EXPIRATION_DATE = 134;
    protected static final int MIN_SERVER_VER_REALIZED_PNL = 135;
    protected static final int MIN_SERVER_VER_LAST_LIQUIDITY = 136;
    protected static final int MIN_SERVER_VER_TICK_BY_TICK = 137;
    protected static final int MIN_SERVER_VER_DECISION_MAKER = 138;
    protected static final int MIN_SERVER_VER_MIFID_EXECUTION = 139;
    protected static final int MIN_SERVER_VER_TICK_BY_TICK_IGNORE_SIZE = 140;
    protected static final int MIN_SERVER_VER_AUTO_PRICE_FOR_HEDGE = 141;
    protected static final int MIN_SERVER_VER_WHAT_IF_EXT_FIELDS = 142;
    protected static final int MIN_SERVER_VER_SCANNER_GENERIC_OPTS = 143;
    protected static final int MIN_SERVER_VER_API_BIND_ORDER = 144;
    protected static final int MIN_SERVER_VER_ORDER_CONTAINER = 145;
    protected static final int MIN_SERVER_VER_SMART_DEPTH = 146;
    protected static final int MIN_SERVER_VER_REMOVE_NULL_ALL_CASTING = 147;
    protected static final int MIN_SERVER_VER_D_PEG_ORDERS = 148;
    protected static final int MIN_SERVER_VER_MKT_DEPTH_PRIM_EXCHANGE = 149;
    protected static final int MIN_SERVER_VER_REQ_COMPLETED_ORDERS = 150;
    protected static final int MIN_SERVER_VER_PRICE_MGMT_ALGO = 151;
    protected static final int MIN_SERVER_VER_STOCK_TYPE = 152;
    protected static final int MIN_SERVER_VER_ENCODE_MSG_ASCII7 = 153;
    protected static final int MIN_SERVER_VER_SEND_ALL_FAMILY_CODES = 154;
    protected static final int MIN_SERVER_VER_NO_DEFAULT_OPEN_CLOSE = 155;
    protected static final int MIN_SERVER_VER_PRICE_BASED_VOLATILITY = 156;
    protected static final int MIN_SERVER_VER_REPLACE_FA_END = 157;
    protected static final int MIN_SERVER_VER_DURATION = 158;
    protected static final int MIN_SERVER_VER_MARKET_DATA_IN_SHARES = 159;
    protected static final int MIN_SERVER_VER_POST_TO_ATS = 160;
    protected static final int MIN_SERVER_VER_WSHE_CALENDAR = 161;
    protected static final int MIN_SERVER_VER_AUTO_CANCEL_PARENT = 162;
    protected static final int MIN_SERVER_VER_FRACTIONAL_SIZE_SUPPORT = 163;
    protected static final int MIN_SERVER_VER_SIZE_RULES = 164;
    protected static final int MIN_SERVER_VER_HISTORICAL_SCHEDULE = 165;
    protected static final int MIN_SERVER_VER_ADVANCED_ORDER_REJECT = 166;
    protected static final int MIN_SERVER_VER_USER_INFO = 167;
    protected static final int MIN_SERVER_VER_CRYPTO_AGGREGATED_TRADES = 168;
    protected static final int MIN_SERVER_VER_MANUAL_ORDER_TIME = 169;
    protected static final int MIN_SERVER_VER_PEGBEST_PEGMID_OFFSETS = 170;
    protected static final int MIN_SERVER_VER_WSH_EVENT_DATA_FILTERS = 171;
    protected static final int MIN_SERVER_VER_IPO_PRICES = 172;
    protected static final int MIN_SERVER_VER_WSH_EVENT_DATA_FILTERS_DATE = 173;
    protected static final int MIN_SERVER_VER_INSTRUMENT_TIMEZONE = 174;
    protected static final int MIN_SERVER_VER_HMDS_MARKET_DATA_IN_SHARES = 175;
    protected static final int MIN_SERVER_VER_BOND_ISSUERID = 176;
    protected static final int MIN_SERVER_VER_FA_PROFILE_DESUPPORT = 177;
    protected static final int MIN_SERVER_VER_PENDING_PRICE_REVISION = 178;
    protected static final int MIN_SERVER_VER_FUND_DATA_FIELDS = 179;
    protected static final int MIN_SERVER_VER_MANUAL_ORDER_TIME_EXERCISE_OPTIONS = 180;
    protected static final int MIN_SERVER_VER_OPEN_ORDER_AD_STRATEGY = 181;
    protected static final int MIN_SERVER_VER_LAST_TRADE_DATE = 182;
    protected static final int MIN_SERVER_VER_CUSTOMER_ACCOUNT = 183;
    protected static final int MIN_SERVER_VER_PROFESSIONAL_CUSTOMER = 184;
    public static final int MIN_VERSION = 100;
    public static final int MAX_VERSION = 184;
    protected EReaderSignal m_signal;
    protected EWrapper m_eWrapper;
    protected int m_serverVersion;
    protected String m_TwsTime;
    protected int m_clientId;
    protected boolean m_extraAuth;
    protected boolean m_useV100Plus = true;
    private String m_optionalCapabilities;
    private String m_connectOptions = "";
    protected String m_host;
    protected ETransport m_socketTransport;

    public boolean isUseV100Plus() {
        return this.m_useV100Plus;
    }

    public int serverVersion() {
        return this.m_serverVersion;
    }

    public String getTwsConnectionTime() {
        return this.m_TwsTime;
    }

    public EWrapper wrapper() {
        return this.m_eWrapper;
    }

    public abstract boolean isConnected();

    protected synchronized void setExtraAuth(boolean bl) {
        this.m_extraAuth = bl;
    }

    public void optionalCapabilities(String string) {
        this.m_optionalCapabilities = string;
    }

    public String optionalCapabilities() {
        return this.m_optionalCapabilities;
    }

    public EClient(EWrapper eWrapper, EReaderSignal eReaderSignal) {
        this.m_eWrapper = eWrapper;
        this.m_signal = eReaderSignal;
        this.m_clientId = -1;
        this.m_extraAuth = false;
        this.m_optionalCapabilities = "";
        this.m_serverVersion = 0;
    }

    protected void sendConnectRequest() throws IOException {
        if (!this.m_useV100Plus || this.m_connectOptions == null) {
            this.send(66);
        } else {
            this.sendV100APIHeader();
        }
    }

    public void disableUseV100Plus() {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return;
        }
        this.m_connectOptions = "";
        this.m_useV100Plus = false;
    }

    public void setConnectOptions(String string) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return;
        }
        this.m_connectOptions = string;
    }

    protected void connectionError() {
        this.m_eWrapper.error(-1, EClientErrors.CONNECT_FAIL.code(), EClientErrors.CONNECT_FAIL.msg(), null);
    }

    protected String checkConnected(String string) {
        if (this.isConnected()) {
            this.m_eWrapper.error(-1, EClientErrors.ALREADY_CONNECTED.code(), EClientErrors.ALREADY_CONNECTED.msg(), null);
            return null;
        }
        if (EClient.IsEmpty(string)) {
            string = "127.0.0.1";
        }
        return string;
    }

    public abstract void eDisconnect();

    public synchronized void startAPI() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(71);
            builder.send(2);
            builder.send(this.m_clientId);
            if (this.m_serverVersion >= 72) {
                builder.send(this.m_optionalCapabilities);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_STARTAPI, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelScannerSubscription(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(23);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANSCANNER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqScannerParameters() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(24);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSCANNERPARAMETERS, exception.toString());
            this.close();
        }
    }

    public synchronized void reqScannerSubscription(int n, ScannerSubscription scannerSubscription, List<TagValue> list, List<TagValue> list2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support API scanner subscription.");
            return;
        }
        if (this.m_serverVersion < 143 && list2 != null) {
            this.error(-1, EClientErrors.UPDATE_TWS, " It does not support API scanner subscription generic filter options");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(22);
            if (this.m_serverVersion < 143) {
                builder.send(4);
            }
            builder.send(n);
            builder.sendMax(scannerSubscription.numberOfRows());
            builder.send(scannerSubscription.instrument());
            builder.send(scannerSubscription.locationCode());
            builder.send(scannerSubscription.scanCode());
            builder.sendMax(scannerSubscription.abovePrice());
            builder.sendMax(scannerSubscription.belowPrice());
            builder.sendMax(scannerSubscription.aboveVolume());
            builder.sendMax(scannerSubscription.marketCapAbove());
            builder.sendMax(scannerSubscription.marketCapBelow());
            builder.send(scannerSubscription.moodyRatingAbove());
            builder.send(scannerSubscription.moodyRatingBelow());
            builder.send(scannerSubscription.spRatingAbove());
            builder.send(scannerSubscription.spRatingBelow());
            builder.send(scannerSubscription.maturityDateAbove());
            builder.send(scannerSubscription.maturityDateBelow());
            builder.sendMax(scannerSubscription.couponRateAbove());
            builder.sendMax(scannerSubscription.couponRateBelow());
            builder.send(scannerSubscription.excludeConvertible());
            if (this.m_serverVersion >= 25) {
                builder.sendMax(scannerSubscription.averageOptionVolumeAbove());
                builder.send(scannerSubscription.scannerSettingPairs());
            }
            if (this.m_serverVersion >= 27) {
                builder.send(scannerSubscription.stockTypeFilter());
            }
            if (this.m_serverVersion >= 143) {
                builder.send(list2);
            }
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQSCANNER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqMktData(int n, Contract contract, String string, boolean bl, boolean bl2, List<TagValue> list) {
        if (!this.isConnected()) {
            this.error(-1, EClientErrors.NOT_CONNECTED, "");
            return;
        }
        if (this.m_serverVersion < 35 && bl) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support snapshot market data requests.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.deltaNeutralContract() != null) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 47 && contract.conid() > 0) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqMarketData.");
            return;
        }
        try {
            Object object;
            Builder builder = this.prepareBuffer();
            builder.send(1);
            builder.send(11);
            builder.send(n);
            if (this.m_serverVersion >= 47) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                builder.send(contract.multiplier());
            }
            builder.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                builder.send(contract.primaryExch());
            }
            builder.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                builder.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    builder.send(0);
                } else {
                    builder.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        object = contract.comboLegs().get(i);
                        builder.send(((ComboLeg)object).conid());
                        builder.send(((ComboLeg)object).ratio());
                        builder.send(((ComboLeg)object).getAction());
                        builder.send(((ComboLeg)object).exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 40) {
                if (contract.deltaNeutralContract() != null) {
                    object = contract.deltaNeutralContract();
                    builder.send(true);
                    builder.send(((DeltaNeutralContract)object).conid());
                    builder.send(((DeltaNeutralContract)object).delta());
                    builder.send(((DeltaNeutralContract)object).price());
                } else {
                    builder.send(false);
                }
            }
            if (this.m_serverVersion >= 31) {
                builder.send(string);
            }
            if (this.m_serverVersion >= 35) {
                builder.send(bl);
            }
            if (this.m_serverVersion >= 114) {
                builder.send(bl2);
            }
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKT, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelHistoricalData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 24) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data query cancellation.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(25);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANHISTDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelRealTimeBars(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support realtime bar data query cancellation.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(51);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANRTBARS, exception.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalData(int n, Contract contract, String string, String string2, String string3, String string4, int n2, int n3, boolean bl, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 16) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical data backfill.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqHistoricalData.");
                return;
            }
            if (this.m_serverVersion < 165 && !EClient.IsEmpty(string4) && string4.equalsIgnoreCase(Types.WhatToShow.SCHEDULE.name())) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support requesting of historical schedule.");
                return;
            }
            Builder builder = this.prepareBuffer();
            builder.send(20);
            if (this.m_serverVersion < 124) {
                builder.send(6);
            }
            builder.send(n);
            if (this.m_serverVersion >= 68) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                builder.send(contract.includeExpired() ? 1 : 0);
            }
            if (this.m_serverVersion >= 20) {
                builder.send(string);
                builder.send(string3);
            }
            builder.send(string2);
            builder.send(n2);
            builder.send(string4);
            if (this.m_serverVersion > 16) {
                builder.send(n3);
            }
            if (Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    builder.send(0);
                } else {
                    builder.send(contract.comboLegs().size());
                    for (int i = 0; i < contract.comboLegs().size(); ++i) {
                        ComboLeg comboLeg = contract.comboLegs().get(i);
                        builder.send(comboLeg.conid());
                        builder.send(comboLeg.ratio());
                        builder.send(comboLeg.getAction());
                        builder.send(comboLeg.exchange());
                    }
                }
            }
            if (this.m_serverVersion >= 124) {
                builder.send(bl);
            }
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQHISTDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void reqHeadTimestamp(int n, Contract contract, String string, int n2, int n3) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 118) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests.");
                return;
            }
            Builder builder = this.prepareBuffer();
            builder.send(87);
            builder.send(n);
            builder.send(contract);
            builder.send(n2);
            builder.send(string);
            builder.send(n3);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQHEADTIMESTAMP, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelHeadTimestamp(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 123) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests canceling.");
                return;
            }
            Builder builder = this.prepareBuffer();
            builder.send(90);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCELHEADTIMESTAMP, exception.toString());
            this.close();
        }
    }

    public synchronized void reqRealTimeBars(int n, Contract contract, int n2, String string, boolean bl, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 34) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support real time bars.");
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqRealTimeBars.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(50);
            builder.send(3);
            builder.send(n);
            if (this.m_serverVersion >= 68) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            builder.send(n2);
            builder.send(string);
            builder.send(bl);
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQRTBARS, exception.toString());
            this.close();
        }
    }

    public synchronized void reqContractDetails(int n, Contract contract) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 4) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty(contract.getSecIdType()) && EClient.IsEmpty(contract.secId()))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in reqContractDetails.");
            return;
        }
        if (this.m_serverVersion < 70 && !EClient.IsEmpty(contract.primaryExch())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support primaryExchange parameter in reqContractDetails.");
            return;
        }
        if (this.m_serverVersion < 176 && !EClient.IsEmpty(contract.issuerId())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support issuerId parameter in reqContractDetails.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(9);
            builder.send(8);
            if (this.m_serverVersion >= 40) {
                builder.send(n);
            }
            if (this.m_serverVersion >= 37) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                builder.send(contract.multiplier());
            }
            if (this.m_serverVersion >= 75) {
                builder.send(contract.exchange());
                builder.send(contract.primaryExch());
            } else if (this.m_serverVersion >= 70) {
                if (!EClient.IsEmpty(contract.primaryExch()) && ("BEST".equals(contract.exchange()) || "SMART".equals(contract.exchange()))) {
                    builder.send(contract.exchange() + ":" + contract.primaryExch());
                } else {
                    builder.send(contract.exchange());
                }
            }
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 31) {
                builder.send(contract.includeExpired());
            }
            if (this.m_serverVersion >= 45) {
                builder.send(contract.getSecIdType());
                builder.send(contract.secId());
            }
            if (this.m_serverVersion >= 176) {
                builder.send(contract.issuerId());
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQCONTRACT, exception.toString());
            this.close();
        }
    }

    public synchronized void reqMktDepth(int n, Contract contract, int n2, boolean bl, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in reqMktDepth.");
            return;
        }
        if (this.m_serverVersion < 146 && bl) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support SMART depth request.");
            return;
        }
        if (this.m_serverVersion < 149 && !EClient.IsEmpty(contract.primaryExch())) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support primaryExch parameter in reqMktDepth.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(10);
            builder.send(5);
            builder.send(n);
            if (this.m_serverVersion >= 68) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                builder.send(contract.multiplier());
            }
            builder.send(contract.exchange());
            if (this.m_serverVersion >= 149) {
                builder.send(contract.primaryExch());
            }
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 19) {
                builder.send(n2);
            }
            if (this.m_serverVersion >= 146) {
                builder.send(bl);
            }
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKTDEPTH, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelMktData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(2);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANMKT, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelMktDepth(int n, boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 6) {
            this.error(-1, EClientErrors.UPDATE_TWS.code(), EClientErrors.UPDATE_TWS.msg());
            return;
        }
        if (this.m_serverVersion < 146 && bl) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support SMART depth cancel.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(11);
            builder.send(1);
            builder.send(n);
            if (this.m_serverVersion >= 146) {
                builder.send(bl);
            }
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANMKTDEPTH, exception.toString());
            this.close();
        }
    }

    public synchronized void exerciseOptions(int n, Contract contract, int n2, int n3, String string, int n4, String string2, String string3, boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 21) {
                this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support options exercise from the API.");
                return;
            }
            if (!(this.m_serverVersion >= 68 || EClient.IsEmpty(contract.tradingClass()) && contract.conid() <= 0)) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId and tradingClass parameters in exerciseOptions.");
                return;
            }
            if (this.m_serverVersion < 180 && !EClient.IsEmpty(string2)) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support manual order time parameter in exerciseOptions.");
                return;
            }
            if (this.m_serverVersion < 183 && !EClient.IsEmpty(string3)) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support customer account parameter in exerciseOptions.");
                return;
            }
            if (this.m_serverVersion < 184 && bl) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support professional customer parameter in exerciseOptions.");
                return;
            }
            Builder builder = this.prepareBuffer();
            builder.send(21);
            builder.send(2);
            builder.send(n);
            if (this.m_serverVersion >= 68) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            builder.send(n2);
            builder.send(n3);
            builder.send(string);
            builder.send(n4);
            if (this.m_serverVersion >= 180) {
                builder.send(string2);
            }
            if (this.m_serverVersion >= 183) {
                builder.send(string3);
            }
            if (this.m_serverVersion >= 184) {
                builder.send(bl);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQMKT, exception.toString());
            this.close();
        }
    }

    public synchronized void placeOrder(int n, Contract contract, Order order) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 35 && (order.scaleInitLevelSize() != Integer.MAX_VALUE || order.scalePriceIncrement() != Double.MAX_VALUE)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Scale orders.");
            return;
        }
        if (this.m_serverVersion < 35 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg object : contract.comboLegs()) {
                if (object.shortSaleSlot() == 0 && EClient.IsEmpty(object.designatedLocation())) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support SSHORT flag for combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 36 && order.whatIf()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support what-if orders.");
            return;
        }
        if (this.m_serverVersion < 40 && contract.deltaNeutralContract() != null) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support delta-neutral orders.");
            return;
        }
        if (this.m_serverVersion < 40 && order.scaleSubsLevelSize() != Integer.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Subsequent Level Size for Scale orders.");
            return;
        }
        if (this.m_serverVersion < 41 && !EClient.IsEmpty(order.getAlgoStrategy())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support algo orders.");
            return;
        }
        if (this.m_serverVersion < 44 && order.notHeld()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support notHeld parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 45 || EClient.IsEmpty(contract.getSecIdType()) && EClient.IsEmpty(contract.secId()))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support secIdType and secId parameters.");
            return;
        }
        if (this.m_serverVersion < 46 && contract.conid() > 0) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && order.exemptCode() != -1) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
            return;
        }
        if (this.m_serverVersion < 52 && !contract.comboLegs().isEmpty()) {
            for (ComboLeg exception : contract.comboLegs()) {
                if (exception.exemptCode() == -1) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support exemptCode parameter.");
                return;
            }
        }
        if (this.m_serverVersion < 54 && !EClient.IsEmpty(order.getHedgeType())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support hedge orders.");
            return;
        }
        if (this.m_serverVersion < 56 && order.optOutSmartRouting()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support optOutSmartRouting parameter.");
            return;
        }
        if (!(this.m_serverVersion >= 58 || order.deltaNeutralConId() <= 0 && EClient.IsEmpty(order.deltaNeutralSettlingFirm()) && EClient.IsEmpty(order.deltaNeutralClearingAccount()) && EClient.IsEmpty(order.deltaNeutralClearingIntent()))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: ConId, SettlingFirm, ClearingAccount, ClearingIntent");
            return;
        }
        if (!(this.m_serverVersion >= 66 || EClient.IsEmpty(order.deltaNeutralOpenClose()) && !order.deltaNeutralShortSale() && order.deltaNeutralShortSaleSlot() <= 0 && EClient.IsEmpty(order.deltaNeutralDesignatedLocation()))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support deltaNeutral parameters: OpenClose, ShortSale, ShortSaleSlot, DesignatedLocation");
            return;
        }
        if (this.m_serverVersion < 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE && (order.scalePriceAdjustValue() != Double.MAX_VALUE || order.scalePriceAdjustInterval() != Integer.MAX_VALUE || order.scaleProfitOffset() != Double.MAX_VALUE || order.scaleAutoReset() || order.scaleInitPosition() != Integer.MAX_VALUE || order.scaleInitFillQty() != Integer.MAX_VALUE || order.scaleRandomPercent())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support Scale order parameters: PriceAdjustValue, PriceAdjustInterval, ProfitOffset, AutoReset, InitPosition, InitFillQty and RandomPercent");
            return;
        }
        if (this.m_serverVersion < 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType()) && !order.orderComboLegs().isEmpty()) {
            for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                if (orderComboLeg.price() == Double.MAX_VALUE) continue;
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support per-leg prices for order combo legs.");
                return;
            }
        }
        if (this.m_serverVersion < 62 && order.trailingPercent() != Double.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support trailing percent parameter");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameters in placeOrder.");
            return;
        }
        if (this.m_serverVersion < 71 && !EClient.IsEmpty(order.algoId())) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support algoId parameter");
        }
        if (!(this.m_serverVersion >= 69 || EClient.IsEmpty(order.scaleTable()) && EClient.IsEmpty(order.activeStartTime()) && EClient.IsEmpty(order.activeStopTime()))) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support scaleTable, activeStartTime and activeStopTime parameters.");
            return;
        }
        if (this.m_serverVersion < 73 && order.solicited()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support order solicited parameter.");
            return;
        }
        if (this.m_serverVersion < 103 && !EClient.IsEmpty(order.modelCode())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support model code parameter.");
            return;
        }
        if (this.m_serverVersion < 105 && !EClient.IsEmpty(order.extOperator())) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support ext operator");
        }
        if (!(this.m_serverVersion >= 106 || EClient.IsEmpty(order.softDollarTier().name()) && EClient.IsEmpty(order.softDollarTier().value()))) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support soft dollar tier");
        }
        if (this.m_serverVersion < 111 && order.cashQty() != Double.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support cash quantity parameter");
            return;
        }
        if (!(this.m_serverVersion >= 138 || EClient.IsEmpty(order.mifid2DecisionMaker()) && EClient.IsEmpty(order.mifid2DecisionAlgo()))) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support MIFID II decision maker parameters");
            return;
        }
        if (!(this.m_serverVersion >= 139 || EClient.IsEmpty(order.mifid2ExecutionTrader()) && EClient.IsEmpty(order.mifid2ExecutionAlgo()))) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support MIFID II execution parameters");
            return;
        }
        if (this.m_serverVersion < 141 && order.dontUseAutoPriceForHedge()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support don't use auto price for hedge parameter.");
            return;
        }
        if (this.m_serverVersion < 145 && order.isOmsContainer()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support oms container parameter.");
            return;
        }
        if (this.m_serverVersion < 148 && order.discretionaryUpToLimitPrice()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support D-Peg orders.");
            return;
        }
        if (this.m_serverVersion < 151 && order.usePriceMgmtAlgo() != null) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support price management algo parameter");
            return;
        }
        if (this.m_serverVersion < 158 && order.duration() != Integer.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support duration attribute");
            return;
        }
        if (this.m_serverVersion < 160 && order.postToAts() != Integer.MAX_VALUE) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support postToAts attribute");
            return;
        }
        if (this.m_serverVersion < 162 && order.autoCancelParent()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support autoCancelParent attribute");
            return;
        }
        if (this.m_serverVersion < 166 && !EClient.IsEmpty(order.advancedErrorOverride())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support advanced error override attribute");
            return;
        }
        if (this.m_serverVersion < 169 && !EClient.IsEmpty(order.manualOrderTime())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support manual order time attribute");
            return;
        }
        if (this.m_serverVersion < 170 && (order.minTradeQty() != Integer.MAX_VALUE || order.minCompeteSize() != Integer.MAX_VALUE || order.competeAgainstBestOffset() != Double.MAX_VALUE || order.midOffsetAtWhole() != Double.MAX_VALUE || order.midOffsetAtHalf() != Double.MAX_VALUE)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support PEG BEST / PEG MID order parameters: minTradeQty, minCompeteSize, competeAgainstBestOffset, midOffsetAtWhole and midOffsetAtHalf");
            return;
        }
        if (this.m_serverVersion < 183 && !EClient.IsEmpty(order.customerAccount())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support customer account parameter");
            return;
        }
        if (this.m_serverVersion < 184 && order.professionalCustomer()) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support professional customer parameter");
            return;
        }
        int n2 = this.m_serverVersion < 44 ? 27 : 45;
        try {
            Builder builder = this.prepareBuffer();
            builder.send(3);
            if (this.m_serverVersion < 145) {
                builder.send(n2);
            }
            builder.send(n);
            if (this.m_serverVersion >= 46) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            if (this.m_serverVersion >= 15) {
                builder.send(contract.multiplier());
            }
            builder.send(contract.exchange());
            if (this.m_serverVersion >= 14) {
                builder.send(contract.primaryExch());
            }
            builder.send(contract.currency());
            if (this.m_serverVersion >= 2) {
                builder.send(contract.localSymbol());
            }
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            if (this.m_serverVersion >= 45) {
                builder.send(contract.getSecIdType());
                builder.send(contract.secId());
            }
            builder.send(order.getAction());
            if (this.m_serverVersion >= 101) {
                builder.send(order.totalQuantity().toString());
            } else {
                builder.send((int)order.totalQuantity().longValue());
            }
            builder.send(order.getOrderType());
            if (this.m_serverVersion < 61) {
                builder.send(order.lmtPrice() == Double.MAX_VALUE ? 0.0 : order.lmtPrice());
            } else {
                builder.sendMax(order.lmtPrice());
            }
            if (this.m_serverVersion < 62) {
                builder.send(order.auxPrice() == Double.MAX_VALUE ? 0.0 : order.auxPrice());
            } else {
                builder.sendMax(order.auxPrice());
            }
            builder.send(order.getTif());
            builder.send(order.ocaGroup());
            builder.send(order.account());
            builder.send(order.openClose());
            builder.send(order.origin());
            builder.send(order.orderRef());
            builder.send(order.transmit());
            if (this.m_serverVersion >= 4) {
                builder.send(order.parentId());
            }
            if (this.m_serverVersion >= 5) {
                builder.send(order.blockOrder());
                builder.send(order.sweepToFill());
                builder.send(order.displaySize());
                builder.send(order.getTriggerMethod());
                if (this.m_serverVersion < 38) {
                    builder.send(false);
                } else {
                    builder.send(order.outsideRth());
                }
            }
            if (this.m_serverVersion >= 7) {
                builder.send(order.hidden());
            }
            if (this.m_serverVersion >= 8 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (contract.comboLegs() == null) {
                    builder.send(0);
                } else {
                    builder.send(contract.comboLegs().size());
                    for (ComboLeg comboLeg : contract.comboLegs()) {
                        builder.send(comboLeg.conid());
                        builder.send(comboLeg.ratio());
                        builder.send(comboLeg.getAction());
                        builder.send(comboLeg.exchange());
                        builder.send(comboLeg.getOpenClose());
                        if (this.m_serverVersion >= 35) {
                            builder.send(comboLeg.shortSaleSlot());
                            builder.send(comboLeg.designatedLocation());
                        }
                        if (this.m_serverVersion < 51) continue;
                        builder.send(comboLeg.exemptCode());
                    }
                }
            }
            if (this.m_serverVersion >= 61 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                if (order.orderComboLegs() == null) {
                    builder.send(0);
                } else {
                    builder.send(order.orderComboLegs().size());
                    for (OrderComboLeg orderComboLeg : order.orderComboLegs()) {
                        builder.sendMax(orderComboLeg.price());
                    }
                }
            }
            if (this.m_serverVersion >= 57 && Types.SecType.BAG.name().equalsIgnoreCase(contract.getSecType())) {
                List<TagValue> list = order.smartComboRoutingParams();
                int n3 = list == null ? 0 : list.size();
                builder.send(n3);
                if (n3 > 0) {
                    Iterator<Object> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TagValue tagValue = (TagValue)iterator.next();
                        builder.send(tagValue.m_tag);
                        builder.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 9) {
                builder.send("");
            }
            if (this.m_serverVersion >= 10) {
                builder.send(order.discretionaryAmt());
            }
            if (this.m_serverVersion >= 11) {
                builder.send(order.goodAfterTime());
            }
            if (this.m_serverVersion >= 12) {
                builder.send(order.goodTillDate());
            }
            if (this.m_serverVersion >= 13) {
                builder.send(order.faGroup());
                builder.send(order.getFaMethod());
                builder.send(order.faPercentage());
                if (this.m_serverVersion < 177) {
                    builder.send("");
                }
            }
            if (this.m_serverVersion >= 103) {
                builder.send(order.modelCode());
            }
            if (this.m_serverVersion >= 18) {
                builder.send(order.shortSaleSlot());
                builder.send(order.designatedLocation());
            }
            if (this.m_serverVersion >= 51) {
                builder.send(order.exemptCode());
            }
            if (this.m_serverVersion >= 19) {
                builder.send(order.getOcaType());
                if (this.m_serverVersion < 38) {
                    builder.send(false);
                }
                builder.send(order.getRule80A());
                builder.send(order.settlingFirm());
                builder.send(order.allOrNone());
                builder.sendMax(order.minQty());
                builder.sendMax(order.percentOffset());
                builder.send(false);
                builder.send(false);
                builder.sendMax(Double.MAX_VALUE);
                builder.sendMax(order.auctionStrategy());
                builder.sendMax(order.startingPrice());
                builder.sendMax(order.stockRefPrice());
                builder.sendMax(order.delta());
                double softDollarTier = this.m_serverVersion == 26 && Util.IsVolOrder(order.orderType()) ? Double.MAX_VALUE : order.stockRangeLower();
                double d = this.m_serverVersion == 26 && Util.IsVolOrder(order.orderType()) ? Double.MAX_VALUE : order.stockRangeUpper();
                builder.sendMax(softDollarTier);
                builder.sendMax(d);
            }
            if (this.m_serverVersion >= 22) {
                builder.send(order.overridePercentageConstraints());
            }
            if (this.m_serverVersion >= 26) {
                builder.sendMax(order.volatility());
                builder.send(order.getVolatilityType());
                if (this.m_serverVersion < 28) {
                    builder.send(order.getDeltaNeutralOrderType().equalsIgnoreCase("MKT"));
                } else {
                    builder.send(order.getDeltaNeutralOrderType());
                    builder.sendMax(order.deltaNeutralAuxPrice());
                    if (this.m_serverVersion >= 58 && !EClient.IsEmpty(order.getDeltaNeutralOrderType())) {
                        builder.send(order.deltaNeutralConId());
                        builder.send(order.deltaNeutralSettlingFirm());
                        builder.send(order.deltaNeutralClearingAccount());
                        builder.send(order.deltaNeutralClearingIntent());
                    }
                    if (this.m_serverVersion >= 66 && !EClient.IsEmpty(order.getDeltaNeutralOrderType())) {
                        builder.send(order.deltaNeutralOpenClose());
                        builder.send(order.deltaNeutralShortSale());
                        builder.send(order.deltaNeutralShortSaleSlot());
                        builder.send(order.deltaNeutralDesignatedLocation());
                    }
                }
                builder.send(order.continuousUpdate());
                if (this.m_serverVersion == 26) {
                    double bl = Util.IsVolOrder(order.orderType()) ? order.stockRangeLower() : Double.MAX_VALUE;
                    double d = Util.IsVolOrder(order.orderType()) ? order.stockRangeUpper() : Double.MAX_VALUE;
                    builder.sendMax(bl);
                    builder.sendMax(d);
                }
                builder.send(order.getReferencePriceType());
            }
            if (this.m_serverVersion >= 30) {
                builder.sendMax(order.trailStopPrice());
            }
            if (this.m_serverVersion >= 62) {
                builder.sendMax(order.trailingPercent());
            }
            if (this.m_serverVersion >= 35) {
                if (this.m_serverVersion >= 40) {
                    builder.sendMax(order.scaleInitLevelSize());
                    builder.sendMax(order.scaleSubsLevelSize());
                } else {
                    builder.send("");
                    builder.sendMax(order.scaleInitLevelSize());
                }
                builder.sendMax(order.scalePriceIncrement());
            }
            if (this.m_serverVersion >= 60 && order.scalePriceIncrement() > 0.0 && order.scalePriceIncrement() != Double.MAX_VALUE) {
                builder.sendMax(order.scalePriceAdjustValue());
                builder.sendMax(order.scalePriceAdjustInterval());
                builder.sendMax(order.scaleProfitOffset());
                builder.send(order.scaleAutoReset());
                builder.sendMax(order.scaleInitPosition());
                builder.sendMax(order.scaleInitFillQty());
                builder.send(order.scaleRandomPercent());
            }
            if (this.m_serverVersion >= 69) {
                builder.send(order.scaleTable());
                builder.send(order.activeStartTime());
                builder.send(order.activeStopTime());
            }
            if (this.m_serverVersion >= 54) {
                builder.send(order.getHedgeType());
                if (!EClient.IsEmpty(order.getHedgeType())) {
                    builder.send(order.hedgeParam());
                }
            }
            if (this.m_serverVersion >= 56) {
                builder.send(order.optOutSmartRouting());
            }
            if (this.m_serverVersion >= 39) {
                builder.send(order.clearingAccount());
                builder.send(order.clearingIntent());
            }
            if (this.m_serverVersion >= 44) {
                builder.send(order.notHeld());
            }
            if (this.m_serverVersion >= 40) {
                if (contract.deltaNeutralContract() != null) {
                    DeltaNeutralContract deltaNeutralContract = contract.deltaNeutralContract();
                    builder.send(true);
                    builder.send(deltaNeutralContract.conid());
                    builder.send(deltaNeutralContract.delta());
                    builder.send(deltaNeutralContract.price());
                } else {
                    builder.send(false);
                }
            }
            if (this.m_serverVersion >= 41) {
                builder.send(order.getAlgoStrategy());
                if (!EClient.IsEmpty(order.getAlgoStrategy())) {
                    List<TagValue> list = order.algoParams();
                    int n4 = list.size();
                    builder.send(n4);
                    for (TagValue tagValue : list) {
                        builder.send(tagValue.m_tag);
                        builder.send(tagValue.m_value);
                    }
                }
            }
            if (this.m_serverVersion >= 71) {
                builder.send(order.algoId());
            }
            if (this.m_serverVersion >= 36) {
                builder.send(order.whatIf());
            }
            if (this.m_serverVersion >= 70) {
                builder.send(order.orderMiscOptions());
            }
            if (this.m_serverVersion >= 73) {
                builder.send(order.solicited());
            }
            if (this.m_serverVersion >= 76) {
                builder.send(order.randomizeSize());
                builder.send(order.randomizePrice());
            }
            if (this.m_serverVersion >= 102) {
                if (Util.IsPegBenchOrder(order.orderType())) {
                    builder.send(order.referenceContractId());
                    builder.send(order.isPeggedChangeAmountDecrease());
                    builder.send(order.peggedChangeAmount());
                    builder.send(order.referenceChangeAmount());
                    builder.send(order.referenceExchangeId());
                }
                builder.send(order.conditions().size());
                if (order.conditions().size() > 0) {
                    for (OrderCondition orderCondition : order.conditions()) {
                        builder.send(orderCondition.type().val());
                        orderCondition.writeTo(builder);
                    }
                    builder.send(order.conditionsIgnoreRth());
                    builder.send(order.conditionsCancelOrder());
                }
                builder.send(order.adjustedOrderType());
                builder.send(order.triggerPrice());
                builder.send(order.lmtPriceOffset());
                builder.send(order.adjustedStopPrice());
                builder.send(order.adjustedStopLimitPrice());
                builder.send(order.adjustedTrailingAmount());
                builder.send(order.adjustableTrailingUnit());
            }
            if (this.m_serverVersion >= 105) {
                builder.send(order.extOperator());
            }
            if (this.m_serverVersion >= 106) {
                SoftDollarTier softDollarTier = order.softDollarTier();
                builder.send(softDollarTier.name());
                builder.send(softDollarTier.value());
            }
            if (this.m_serverVersion >= 111) {
                builder.sendMax(order.cashQty());
            }
            if (this.m_serverVersion >= 138) {
                builder.send(order.mifid2DecisionMaker());
                builder.send(order.mifid2DecisionAlgo());
            }
            if (this.m_serverVersion >= 139) {
                builder.send(order.mifid2ExecutionTrader());
                builder.send(order.mifid2ExecutionAlgo());
            }
            if (this.m_serverVersion >= 141) {
                builder.send(order.dontUseAutoPriceForHedge());
            }
            if (this.m_serverVersion >= 145) {
                builder.send(order.isOmsContainer());
            }
            if (this.m_serverVersion >= 148) {
                builder.send(order.discretionaryUpToLimitPrice());
            }
            if (this.m_serverVersion >= 151) {
                builder.send(order.usePriceMgmtAlgo());
            }
            if (this.m_serverVersion >= 158) {
                builder.send(order.duration());
            }
            if (this.m_serverVersion >= 160) {
                builder.send(order.postToAts());
            }
            if (this.m_serverVersion >= 162) {
                builder.send(order.autoCancelParent());
            }
            if (this.m_serverVersion >= 166) {
                builder.send(order.advancedErrorOverride());
            }
            if (this.m_serverVersion >= 169) {
                builder.send(order.manualOrderTime());
            }
            if (this.m_serverVersion >= 170) {
                if (contract.exchange().equals("IBKRATS")) {
                    builder.sendMax(order.minTradeQty());
                }
                boolean bl = false;
                if (Util.IsPegBestOrder(order.orderType()).booleanValue()) {
                    builder.sendMax(order.minCompeteSize());
                    builder.sendMax(order.competeAgainstBestOffset());
                    if (order.isCompeteAgainstBestOffsetUpToMid()) {
                        bl = true;
                    }
                } else if (Util.IsPegMidOrder(order.orderType())) {
                    bl = true;
                }
                if (bl) {
                    builder.sendMax(order.midOffsetAtWhole());
                    builder.sendMax(order.midOffsetAtHalf());
                }
            }
            if (this.m_serverVersion >= 183) {
                builder.send(order.customerAccount());
            }
            if (this.m_serverVersion >= 184) {
                builder.send(order.professionalCustomer());
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_ORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqAccountUpdates(boolean bl, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(6);
            builder.send(2);
            builder.send(bl);
            if (this.m_serverVersion >= 9) {
                builder.send(string);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_ACCT, exception.toString());
            this.close();
        }
    }

    public synchronized void reqExecutions(int n, ExecutionFilter executionFilter) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(7);
            builder.send(3);
            if (this.m_serverVersion >= 42) {
                builder.send(n);
            }
            if (this.m_serverVersion >= 9) {
                builder.send(executionFilter.clientId());
                builder.send(executionFilter.acctCode());
                builder.send(executionFilter.time());
                builder.send(executionFilter.symbol());
                builder.send(executionFilter.secType());
                builder.send(executionFilter.exchange());
                builder.send(executionFilter.side());
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_EXEC, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelOrder(int n, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 169 && !EClient.IsEmpty(string)) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support manual order cancel time attribute");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(4);
            builder.send(1);
            builder.send(n);
            if (this.m_serverVersion >= 169) {
                builder.send(string);
            }
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(5);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqIds(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(8);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqNewsBulletins(boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(12);
            builder.send(1);
            builder.send(bl);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelNewsBulletins() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(13);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void setServerLogLevel(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(14);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_SERVER_LOG_LEVEL, exception.toString());
            this.close();
        }
    }

    public synchronized void reqAutoOpenOrders(boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(15);
            builder.send(1);
            builder.send(bl);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqAllOpenOrders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(16);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, exception.toString());
            this.close();
        }
    }

    public synchronized void reqManagedAccts() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(17);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_OORDER, exception.toString());
            this.close();
        }
    }

    public void requestFA(Types.FADataType fADataType) {
        this.requestFA(fADataType.id());
    }

    public synchronized void requestFA(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion >= 177 && n == 2) {
            this.error(-1, EClientErrors.FA_PROFILE_NOT_SUPPORTED.code(), EClientErrors.FA_PROFILE_NOT_SUPPORTED.msg());
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(18);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_FA_REQUEST, exception.toString());
            this.close();
        }
    }

    public void replaceFA(int n, Types.FADataType fADataType, String string) {
        this.replaceFA(n, fADataType.id(), string);
    }

    public synchronized void replaceFA(int n, int n2, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion >= 177 && n2 == 2) {
            this.error(n, EClientErrors.FA_PROFILE_NOT_SUPPORTED.code(), EClientErrors.FA_PROFILE_NOT_SUPPORTED.msg());
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(19);
            builder.send(1);
            builder.send(n2);
            builder.send(string);
            if (this.m_serverVersion >= 157) {
                builder.send(n);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_FA_REPLACE, exception.toString());
            this.close();
        }
    }

    public synchronized void reqCurrentTime() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 33) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support current time requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(49);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCURRTIME, exception.toString());
            this.close();
        }
    }

    public synchronized void reqFundamentalData(int n, Contract contract, String string, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        if (this.m_serverVersion < 68 && contract.conid() > 0) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support conId parameter in reqFundamentalData.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(52);
            builder.send(2);
            builder.send(n);
            if (this.m_serverVersion >= 68) {
                builder.send(contract.conid());
            }
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            builder.send(string);
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQFUNDDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelFundamentalData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 40) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support fundamental data requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(53);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANFUNDDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void calculateImpliedVolatility(int n, Contract contract, double d, double d2, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 49) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateImpliedVolatility.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(54);
            builder.send(2);
            builder.send(n);
            builder.send(contract.conid());
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            builder.send(d);
            builder.send(d2);
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQCALCIMPLIEDVOLAT, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateImpliedVolatility(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate implied volatility cancellation.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(56);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCALCIMPLIEDVOLAT, exception.toString());
            this.close();
        }
    }

    public synchronized void calculateOptionPrice(int n, Contract contract, double d, double d2, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate option price requests.");
            return;
        }
        if (this.m_serverVersion < 68 && !EClient.IsEmpty(contract.tradingClass())) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support tradingClass parameter in calculateOptionPrice.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(55);
            builder.send(2);
            builder.send(n);
            builder.send(contract.conid());
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            if (this.m_serverVersion >= 68) {
                builder.send(contract.tradingClass());
            }
            builder.send(d);
            builder.send(d2);
            if (this.m_serverVersion >= 70) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQCALCOPTIONPRICE, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelCalculateOptionPrice(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 50) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support calculate option price cancellation.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(57);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCALCOPTIONPRICE, exception.toString());
            this.close();
        }
    }

    public synchronized void reqGlobalCancel() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 53) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support globalCancel requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(58);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQGLOBALCANCEL, exception.toString());
            this.close();
        }
    }

    public synchronized void reqMarketDataType(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 55) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support marketDataType requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(59);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETDATATYPE, exception.toString());
            this.close();
        }
    }

    public synchronized void reqPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position requests.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(61);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_REQPOSITIONS, iOException.toString());
        }
    }

    public synchronized void reqSecDefOptParams(int n, String string, String string2, String string3, int n2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 104) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support security definition option requests.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(78);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            builder.send(string3);
            builder.send(n2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQSECDEFOPTPARAMS, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqSoftDollarTiers(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 106) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support soft dollar tier requests.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(79);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_REQSOFTDOLLARTIERS, iOException.toString());
        }
    }

    public synchronized void cancelPositions() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support position cancellation.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(64);
            builder.send(1);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_CANPOSITIONS, iOException.toString());
        }
    }

    public synchronized void reqPositionsMulti(int n, String string, String string2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support positions multi request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(74);
            builder.send(1);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQPOSITIONSMULTI, iOException.toString());
            this.close();
        }
    }

    public synchronized void cancelPositionsMulti(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support positions multi cancellation.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(75);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_CANPOSITIONSMULTI, iOException.toString());
        }
    }

    public synchronized void cancelAccountUpdatesMulti(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account updates multi cancellation.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(77);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_CANACCOUNTUPDATESMULTI, iOException.toString());
        }
    }

    public synchronized void reqAccountUpdatesMulti(int n, String string, String string2, boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 103) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account updates multi requests.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(76);
            builder.send(1);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            builder.send(bl);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQACCOUNTUPDATESMULTI, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqAccountSummary(int n, String string, String string2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary requests.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(62);
            builder.send(1);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQACCOUNTDATA, iOException.toString());
            this.close();
        }
    }

    public synchronized void cancelAccountSummary(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 67) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support account summary cancellation.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(63);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_CANACCOUNTDATA, iOException.toString());
        }
    }

    public synchronized void verifyRequest(String string, String string2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(65);
            builder.send(1);
            builder.send(string);
            builder.send(string2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYREQUEST, iOException.toString());
            this.close();
        }
    }

    public synchronized void verifyMessage(String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(66);
            builder.send(1);
            builder.send(string);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYMESSAGE, iOException.toString());
            this.close();
        }
    }

    public synchronized void verifyAndAuthRequest(String string, String string2, String string3) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification request.");
            return;
        }
        if (!this.m_extraAuth) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, "  Intent to authenticate needs to be expressed during initial connect request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(72);
            builder.send(1);
            builder.send(string);
            builder.send(string2);
            builder.send(string3);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHREQUEST, iOException.toString());
            this.close();
        }
    }

    public synchronized void verifyAndAuthMessage(String string, String string2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 74) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support verification message sending.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(73);
            builder.send(1);
            builder.send(string);
            builder.send(string2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(-1, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_VERIFYANDAUTHMESSAGE, iOException.toString());
            this.close();
        }
    }

    public synchronized void queryDisplayGroups(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support queryDisplayGroups request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(67);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_QUERYDISPLAYGROUPS, iOException.toString());
        }
    }

    public synchronized void subscribeToGroupEvents(int n, int n2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support subscribeToGroupEvents request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(68);
            builder.send(1);
            builder.send(n);
            builder.send(n2);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_SUBSCRIBETOGROUPEVENTS, iOException.toString());
        }
    }

    public synchronized void updateDisplayGroup(int n, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support updateDisplayGroup request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(69);
            builder.send(1);
            builder.send(n);
            builder.send(string);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_UPDATEDISPLAYGROUP, iOException.toString());
            this.close();
        }
    }

    public synchronized void unsubscribeFromGroupEvents(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 70) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support unsubscribeFromGroupEvents request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(70);
            builder.send(1);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_UNSUBSCRIBEFROMGROUPEVENTS, iOException.toString());
        }
    }

    public synchronized void reqMatchingSymbols(int n, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 108) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support matching symbols request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(81);
            builder.send(n);
            builder.send(string);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQMATCHINGSYMBOLS, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqFamilyCodes() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 107) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support family codes request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(80);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_REQFAMILYCODES, iOException.toString());
        }
    }

    public synchronized void reqMktDepthExchanges() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 112) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support market depth exchanges request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(82);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMKTDEPTHEXCHANGES, iOException.toString());
        }
    }

    public synchronized void reqSmartComponents(int n, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 114) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support smart components request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(83);
            builder.send(n);
            builder.send(string);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQSMARTCOMPONENTS, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqNewsProviders() {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 115) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support news providers request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(85);
            this.closeAndSend(builder);
        }
        catch (IOException iOException) {
            this.error(-1, EClientErrors.FAIL_SEND_REQNEWSPROVIDERS, iOException.toString());
        }
    }

    public synchronized void reqNewsArticle(int n, String string, String string2, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 116) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support news article request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(84);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            if (this.m_serverVersion >= 128) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQNEWSARTICLE, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalNews(int n, int n2, String string, String string2, String string3, int n3, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 117) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support historical news request.");
            return;
        }
        Builder builder = this.prepareBuffer();
        try {
            builder.send(86);
            builder.send(n);
            builder.send(n2);
            builder.send(string);
            builder.send(string2);
            builder.send(string3);
            builder.send(n3);
            if (this.m_serverVersion >= 128) {
                builder.send(list);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (IOException iOException) {
            this.error(n, EClientErrors.FAIL_SEND_REQHISTORICALNEWS, iOException.toString());
            this.close();
        }
    }

    public synchronized void reqHistogramData(int n, Contract contract, boolean bl, String string) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        try {
            if (this.m_serverVersion < 119) {
                this.error(n, EClientErrors.UPDATE_TWS, "  It does not support histogram requests.");
                return;
            }
            Builder builder = this.prepareBuffer();
            builder.send(88);
            builder.send(n);
            builder.send(contract);
            builder.send(bl ? 1 : 0);
            builder.send(string);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQHISTOGRAMDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelHistogramData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 119) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support head time stamp requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(89);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCELHISTOGRAMDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void reqMarketRule(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 126) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support market rule requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(91);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQMARKETRULE, exception.toString());
            this.close();
        }
    }

    public synchronized void reqPnL(int n, String string, String string2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(92);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQPNL, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelPnL(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(93);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCELPNL, exception.toString());
            this.close();
        }
    }

    public synchronized void reqPnLSingle(int n, String string, String string2, int n2) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(94);
            builder.send(n);
            builder.send(string);
            builder.send(string2);
            builder.send(n2);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQPNLSINGLE, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelPnLSingle(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 127) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support PnL requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(95);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_CANCELPNLSINGLE, exception.toString());
            this.close();
        }
    }

    public synchronized void reqHistoricalTicks(int n, Contract contract, String string, String string2, int n2, String string3, int n3, boolean bl, List<TagValue> list) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 130) {
            this.error(n, EClientErrors.UPDATE_TWS, "  It does not support historical ticks request.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(96);
            builder.send(n);
            builder.send(contract);
            builder.send(string);
            builder.send(string2);
            builder.send(n2);
            builder.send(string3);
            builder.send(n3);
            builder.send(bl);
            builder.send(list);
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQHISTORICALTICKS, exception.toString());
            this.close();
        }
    }

    public synchronized void reqTickByTickData(int n, Contract contract, String string, int n2, boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 137) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support tick-by-tick data requests.");
            return;
        }
        if (this.m_serverVersion < 140 && (n2 != 0 || bl)) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support ignoreSize and numberOfTicks parameters in tick-by-tick data requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(97);
            builder.send(n);
            builder.send(contract.conid());
            builder.send(contract.symbol());
            builder.send(contract.getSecType());
            builder.send(contract.lastTradeDateOrContractMonth());
            builder.send(contract.strike());
            builder.send(contract.getRight());
            builder.send(contract.multiplier());
            builder.send(contract.exchange());
            builder.send(contract.primaryExch());
            builder.send(contract.currency());
            builder.send(contract.localSymbol());
            builder.send(contract.tradingClass());
            builder.send(string);
            if (this.m_serverVersion >= 140) {
                builder.send(n2);
                builder.send(bl);
            }
            this.closeAndSend(builder);
        }
        catch (EClientException eClientException) {
            this.error(n, eClientException.error(), eClientException.text());
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQTICKBYTICKDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelTickByTickData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 137) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support tick-by-tick data cancels.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(98);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CANCELTICKBYTICKDATA, exception.toString());
            this.close();
        }
    }

    public synchronized void reqCompletedOrders(boolean bl) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 150) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support completed orders requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(99);
            builder.send(bl);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQCOMPLETEDORDERS, exception.toString());
            this.close();
        }
    }

    public synchronized void reqWshMetaData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(100);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQ_WSH_META_DATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelWshMetaData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(101);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CAN_WSH_META_DATA, exception.toString());
            this.close();
        }
    }

    public synchronized void reqWshEventData(int n, WshEventData wshEventData) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        if (this.m_serverVersion < 171 && (!EClient.IsEmpty(wshEventData.filter()) || wshEventData.fillWatchlist() || wshEventData.fillPortfolio() || wshEventData.fillCompetitors())) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSH event data filters.");
            return;
        }
        if (!(this.m_serverVersion >= 173 || EClient.IsEmpty(wshEventData.startDate()) && EClient.IsEmpty(wshEventData.endDate()) && wshEventData.totalLimit() == Integer.MAX_VALUE)) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSH event data date filters.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(102);
            builder.send(n);
            builder.send(wshEventData.conId());
            if (this.m_serverVersion >= 171) {
                builder.send(wshEventData.filter());
                builder.send(wshEventData.fillWatchlist());
                builder.send(wshEventData.fillPortfolio());
                builder.send(wshEventData.fillCompetitors());
            }
            if (this.m_serverVersion >= 173) {
                builder.send(wshEventData.startDate());
                builder.send(wshEventData.endDate());
                builder.send(wshEventData.totalLimit());
            }
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_REQ_WSH_EVENT_DATA, exception.toString());
            this.close();
        }
    }

    public synchronized void cancelWshEventData(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 161) {
            this.error(-1, EClientErrors.UPDATE_TWS, "  It does not support WSHE Calendar API.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(103);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(-1, EClientErrors.FAIL_SEND_CAN_WSH_EVENT_DATA, exception.toString());
            this.close();
        }
    }

    public synchronized void reqUserInfo(int n) {
        if (!this.isConnected()) {
            this.notConnected();
            return;
        }
        if (this.m_serverVersion < 167) {
            this.error(n, EClientErrors.UPDATE_TWS, " It does not support user info requests.");
            return;
        }
        try {
            Builder builder = this.prepareBuffer();
            builder.send(104);
            builder.send(n);
            this.closeAndSend(builder);
        }
        catch (Exception exception) {
            this.error(n, EClientErrors.FAIL_SEND_REQ_USER_INFO, exception.toString());
            this.close();
        }
    }

    @Deprecated
    protected synchronized void error(String string) {
        this.m_eWrapper.error(string);
    }

    protected synchronized void error(int n, int n2, String string) {
        this.m_eWrapper.error(n, n2, string, null);
    }

    protected void close() {
        this.eDisconnect();
        this.wrapper().connectionClosed();
    }

    protected void error(int n, EClientErrors.CodeMsgPair codeMsgPair, String string) {
        this.error(n, codeMsgPair.code(), codeMsgPair.msg() + string);
    }

    protected abstract Builder prepareBuffer();

    protected abstract void closeAndSend(Builder var1) throws IOException;

    private void sendV100APIHeader() throws IOException {
        try (Builder builder = new Builder(1024);){
            builder.send("API\u0000".getBytes(StandardCharsets.UTF_8));
            String string = this.buildVersionString(100, 184);
            if (!EClient.IsEmpty(this.m_connectOptions)) {
                string = string + " " + this.m_connectOptions;
            }
            int n = builder.allocateLengthHeader();
            builder.send(string.getBytes(StandardCharsets.UTF_8));
            builder.updateLength(n);
            this.sendMsg(new EMessage(builder));
        }
    }

    private String buildVersionString(int n, int n2) {
        return "v" + (n < n2 ? n + ".." + n2 : Integer.valueOf(n));
    }

    protected void sendMsg(EMessage eMessage) throws IOException {
        this.m_socketTransport.send(eMessage);
    }

    private static boolean IsEmpty(String string) {
        return Util.StringIsEmpty(string);
    }

    protected void notConnected() {
        this.error(-1, EClientErrors.NOT_CONNECTED, "");
    }

    public String connectedHost() {
        return this.m_host;
    }

    protected void send(int n) throws IOException {
        this.send(String.valueOf(n));
    }

    protected void send(String string) throws IOException {
        try (Builder builder = new Builder(1024);){
            builder.send(string);
            this.sendMsg(new EMessage(builder));
        }
    }
}

