/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Util;
import java.math.BigDecimal;
import java.math.MathContext;
import java.text.DecimalFormat;

public class Decimal
implements Comparable<Decimal> {
    private static final String NAN_STRING = Double.toString(Double.NaN);
    public static final MathContext MATH_CONTEXT = MathContext.DECIMAL64;
    public static final Decimal ZERO = new Decimal(BigDecimal.ZERO);
    public static final Decimal ONE = new Decimal(BigDecimal.ONE);
    public static final Decimal MINUS_ONE = ONE.negate();
    public static final Decimal INVALID = new Decimal(BigDecimal.valueOf(Long.MIN_VALUE));
    public static final Decimal NaN = new Decimal(BigDecimal.valueOf(Long.MIN_VALUE)){

        @Override
        public long longValue() {
            return Long.MAX_VALUE;
        }

        @Override
        public String toString() {
            return NAN_STRING;
        }
    };
    public static final Decimal ONE_HUNDRED = new Decimal(BigDecimal.valueOf(100L));
    private final BigDecimal m_value;

    public int hashCode() {
        return this.m_value.hashCode();
    }

    public BigDecimal value() {
        return this.m_value;
    }

    public boolean isZero() {
        return Decimal.isZero(this.m_value);
    }

    private static boolean isZero(BigDecimal bigDecimal) {
        return bigDecimal == BigDecimal.ZERO || bigDecimal.signum() == 0;
    }

    public boolean isValid() {
        return this != INVALID && this != NaN;
    }

    public static Decimal get(BigDecimal bigDecimal) {
        Decimal decimal = bigDecimal == null ? INVALID : (Decimal.isZero(bigDecimal) ? ZERO : new Decimal(bigDecimal));
        return decimal;
    }

    public static final Decimal get(double d) {
        Decimal decimal;
        if (d == Double.MAX_VALUE) {
            decimal = INVALID;
        } else if (d == 0.0) {
            decimal = ZERO;
        } else if (Double.isNaN(d) || Double.isInfinite(d)) {
            decimal = NaN;
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("#");
            decimalFormat.setMaximumFractionDigits(16);
            decimal = Decimal.parse(decimalFormat.format(d));
        }
        return decimal;
    }

    public static Decimal get(long l) {
        Decimal decimal = l == Long.MAX_VALUE ? INVALID : (l == 0L ? ZERO : new Decimal(l));
        return decimal;
    }

    private Decimal(double d) {
        BigDecimal bigDecimal = new BigDecimal(d, MATH_CONTEXT);
        this.m_value = bigDecimal.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    private Decimal(long l) {
        BigDecimal bigDecimal = new BigDecimal(l, MATH_CONTEXT);
        this.m_value = bigDecimal.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    private Decimal(BigDecimal bigDecimal) {
        this.m_value = bigDecimal.setScale(16, MATH_CONTEXT.getRoundingMode());
    }

    public static boolean isValidNotZeroValue(Decimal decimal) {
        return Decimal.isValid(decimal) && !decimal.isZero();
    }

    public static boolean isValid(Decimal decimal) {
        return decimal != null && decimal.isValid();
    }

    public static Decimal parse(String string) {
        if (Util.StringIsEmpty(string)) {
            return null;
        }
        if (NAN_STRING.equals(string)) {
            return NaN;
        }
        try {
            string = string.trim().replaceAll(",", "");
            BigDecimal bigDecimal = new BigDecimal(string.toCharArray(), 0, string.length(), MATH_CONTEXT);
            return new Decimal(bigDecimal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public Decimal negate() {
        return this.isValid() ? Decimal.get(this.m_value.negate()) : this;
    }

    public Decimal add(Decimal decimal) {
        return !Decimal.isValid(decimal) || decimal.isZero() ? this : (this.isZero() || !this.isValid() ? decimal : Decimal.get(this.m_value.add(decimal.value())));
    }

    public Decimal divide(Decimal decimal) {
        Decimal decimal2;
        if (ONE.equals(decimal) || this.isZero()) {
            decimal2 = this;
        } else {
            decimal2 = INVALID;
            if (this.isValid() && Decimal.isValid(decimal)) {
                try {
                    decimal2 = Decimal.get(this.m_value.divide(decimal.value(), MATH_CONTEXT));
                }
                catch (ArithmeticException arithmeticException) {
                    // empty catch block
                }
            }
        }
        return decimal2;
    }

    public Decimal multiply(Decimal decimal) {
        return decimal == null ? null : (this.isZero() || decimal.isZero() ? ZERO : (this.isValid() && decimal.isValid() ? (ONE.equals(decimal) ? this : Decimal.get(this.m_value.multiply(decimal.value()))) : INVALID));
    }

    public boolean equals(Object object) {
        return object instanceof Decimal && this.compareTo((Decimal)object) == 0;
    }

    @Override
    public int compareTo(Decimal decimal) {
        return decimal == this ? 0 : (decimal == null ? 1 : (this.isValid() ? (decimal.isValid() ? this.m_value.compareTo(decimal.m_value) : 1) : (decimal.isValid() ? -1 : 0)));
    }

    public static int compare(Decimal decimal, Decimal decimal2) {
        return decimal.value().compareTo(decimal2.value());
    }

    public String toString() {
        return this.isValid() ? this.m_value.stripTrailingZeros().toPlainString() : "";
    }

    public long longValue() {
        return this.isValid() ? this.m_value.longValue() : Long.MAX_VALUE;
    }
}

