/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.Contract;
import com.ib.client.ContractDetails;
import com.ib.client.ContractLookuper;
import com.ib.client.OperatorCondition;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public abstract class ContractCondition
extends OperatorCondition {
    private static final String OF = " of ";
    private static final String ON = " on ";
    private static final String LEFT_PARENTHESIS = "(";
    private static final String RIGHT_PARENTHESIS = ")";
    private int m_conId;
    private String m_exchange;

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(ContractLookuper contractLookuper) {
        Contract contract = new Contract();
        contract.conid(this.conId());
        contract.exchange(this.exchange());
        List<ContractDetails> list = contractLookuper == null ? null : contractLookuper.lookupContract(contract);
        String string = list != null && !list.isEmpty() ? list.get(0).contract().symbol() + " " + list.get(0).contract().secType() + ON + list.get(0).contract().exchange() : this.conId() + LEFT_PARENTHESIS + this.exchange() + RIGHT_PARENTHESIS;
        return (Object)((Object)this.type()) + OF + string + super.toString();
    }

    @Override
    public void readFrom(ObjectInput objectInput) throws IOException {
        super.readFrom(objectInput);
        this.m_conId = objectInput.readInt();
        this.m_exchange = objectInput.readUTF();
    }

    @Override
    public void writeTo(ObjectOutput objectOutput) throws IOException {
        super.writeTo(objectOutput);
        objectOutput.writeInt(this.m_conId);
        objectOutput.writeUTF(this.m_exchange);
    }

    public int conId() {
        return this.m_conId;
    }

    public void conId(int n) {
        this.m_conId = n;
    }

    public String exchange() {
        return this.m_exchange;
    }

    public void exchange(String string) {
        this.m_exchange = string;
    }

    @Override
    public boolean tryToParse(String string) {
        try {
            if (!string.substring(0, string.indexOf(OF)).equals(this.type().name())) {
                return false;
            }
            string = string.substring(string.indexOf(OF) + OF.length());
            this.m_conId = Integer.parseInt(string.substring(0, string.indexOf(LEFT_PARENTHESIS)));
            string = string.substring(string.indexOf(LEFT_PARENTHESIS) + 1);
            this.m_exchange = string.substring(0, string.indexOf(RIGHT_PARENTHESIS));
            string = string.substring(string.indexOf(RIGHT_PARENTHESIS) + 1);
            return super.tryToParse(string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

