/*
 * Decompiled with CFR 0.152.
 */
package com.ib.client;

import com.ib.client.ComboLeg;
import com.ib.client.DeltaNeutralContract;
import com.ib.client.Types;
import com.ib.client.Util;
import java.util.ArrayList;
import java.util.List;

public class Contract
implements Cloneable {
    private int m_conid;
    private String m_symbol;
    private String m_secType;
    private String m_lastTradeDateOrContractMonth;
    private String m_lastTradeDate;
    private double m_strike;
    private String m_right;
    private String m_multiplier;
    private String m_exchange;
    private String m_primaryExch;
    private String m_currency;
    private String m_localSymbol;
    private String m_tradingClass;
    private String m_secIdType;
    private String m_secId;
    private String m_description;
    private String m_issuerId;
    private DeltaNeutralContract m_deltaNeutralContract;
    private boolean m_includeExpired;
    private String m_comboLegsDescrip;
    private List<ComboLeg> m_comboLegs = new ArrayList<ComboLeg>();

    public double strike() {
        return this.m_strike;
    }

    public int conid() {
        return this.m_conid;
    }

    public Types.SecIdType secIdType() {
        return Types.SecIdType.get(this.m_secIdType);
    }

    public String getSecIdType() {
        return this.m_secIdType;
    }

    public Types.SecType secType() {
        return Types.SecType.get(this.m_secType);
    }

    public String getSecType() {
        return this.m_secType;
    }

    public String currency() {
        return this.m_currency;
    }

    public String exchange() {
        return this.m_exchange;
    }

    public String primaryExch() {
        return this.m_primaryExch;
    }

    public String lastTradeDateOrContractMonth() {
        return this.m_lastTradeDateOrContractMonth;
    }

    public String lastTradeDate() {
        return this.m_lastTradeDate;
    }

    public String localSymbol() {
        return this.m_localSymbol;
    }

    public String tradingClass() {
        return this.m_tradingClass;
    }

    public String multiplier() {
        return this.m_multiplier;
    }

    public Types.Right right() {
        return Types.Right.get(this.m_right);
    }

    public String getRight() {
        return this.m_right;
    }

    public String secId() {
        return this.m_secId;
    }

    public String symbol() {
        return this.m_symbol;
    }

    public boolean includeExpired() {
        return this.m_includeExpired;
    }

    public DeltaNeutralContract deltaNeutralContract() {
        return this.m_deltaNeutralContract;
    }

    public List<ComboLeg> comboLegs() {
        return this.m_comboLegs;
    }

    public String comboLegsDescrip() {
        return this.m_comboLegsDescrip;
    }

    public String description() {
        return this.m_description;
    }

    public String issuerId() {
        return this.m_issuerId;
    }

    public void conid(int n) {
        this.m_conid = n;
    }

    public void currency(String string) {
        this.m_currency = string;
    }

    public void exchange(String string) {
        this.m_exchange = string;
    }

    public void lastTradeDateOrContractMonth(String string) {
        this.m_lastTradeDateOrContractMonth = string;
    }

    public void lastTradeDate(String string) {
        this.m_lastTradeDate = string;
    }

    public void localSymbol(String string) {
        this.m_localSymbol = string;
    }

    public void tradingClass(String string) {
        this.m_tradingClass = string;
    }

    public void multiplier(String string) {
        this.m_multiplier = string;
    }

    public void primaryExch(String string) {
        this.m_primaryExch = string;
    }

    public void right(Types.Right right) {
        this.m_right = right == null ? null : right.getApiString();
    }

    public void right(String string) {
        this.m_right = string;
    }

    public void secId(String string) {
        this.m_secId = string;
    }

    public void secIdType(Types.SecIdType secIdType) {
        this.m_secIdType = secIdType == null ? null : secIdType.getApiString();
    }

    public void secIdType(String string) {
        this.m_secIdType = string;
    }

    public void secType(Types.SecType secType) {
        this.m_secType = secType == null ? null : secType.getApiString();
    }

    public void secType(String string) {
        this.m_secType = string;
    }

    public void strike(double d) {
        this.m_strike = d;
    }

    public void symbol(String string) {
        this.m_symbol = string;
    }

    public void deltaNeutralContract(DeltaNeutralContract deltaNeutralContract) {
        this.m_deltaNeutralContract = deltaNeutralContract;
    }

    public void includeExpired(boolean bl) {
        this.m_includeExpired = bl;
    }

    public void comboLegs(List<ComboLeg> list) {
        this.m_comboLegs = list;
    }

    public void comboLegsDescrip(String string) {
        this.m_comboLegsDescrip = string;
    }

    public void description(String string) {
        this.m_description = string;
    }

    public void issuerId(String string) {
        this.m_issuerId = string;
    }

    public Contract() {
        this.m_conid = 0;
        this.m_strike = 0.0;
        this.m_includeExpired = false;
    }

    public Contract clone() {
        try {
            Contract contract = (Contract)super.clone();
            contract.m_comboLegs = contract.m_comboLegs != null ? new ArrayList<ComboLeg>(contract.m_comboLegs) : new ArrayList<ComboLeg>();
            return contract;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public Contract(int n, String string, String string2, String string3, String string4, double d, String string5, String string6, String string7, String string8, String string9, String string10, List<ComboLeg> list, String string11, boolean bl, String string12, String string13, String string14, String string15) {
        this.m_conid = n;
        this.m_symbol = string;
        this.m_secType = string2;
        this.m_lastTradeDateOrContractMonth = string3;
        this.m_lastTradeDate = string4;
        this.m_strike = d;
        this.m_right = string5;
        this.m_multiplier = string6;
        this.m_exchange = string7;
        this.m_currency = string8;
        this.m_includeExpired = bl;
        this.m_localSymbol = string9;
        this.m_tradingClass = string10;
        this.m_comboLegs = list;
        this.m_primaryExch = string11;
        this.m_secIdType = string12;
        this.m_secId = string13;
        this.m_description = string14;
        this.m_issuerId = string15;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Contract)) {
            return false;
        }
        Contract contract = (Contract)object;
        if (this.m_conid != contract.m_conid) {
            return false;
        }
        if (Util.StringCompare(this.m_secType, contract.m_secType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_symbol, contract.m_symbol) != 0 || Util.StringCompare(this.m_exchange, contract.m_exchange) != 0 || Util.StringCompare(this.m_primaryExch, contract.m_primaryExch) != 0 || Util.StringCompare(this.m_currency, contract.m_currency) != 0) {
            return false;
        }
        if (!"BOND".equals(this.m_secType)) {
            if (this.m_strike != contract.m_strike) {
                return false;
            }
            if (Util.StringCompare(this.m_lastTradeDateOrContractMonth, contract.m_lastTradeDateOrContractMonth) != 0 || Util.StringCompare(this.m_lastTradeDate, contract.m_lastTradeDate) != 0 || Util.StringCompare(this.m_right, contract.m_right) != 0 || Util.StringCompare(this.m_multiplier, contract.m_multiplier) != 0 || Util.StringCompare(this.m_localSymbol, contract.m_localSymbol) != 0 || Util.StringCompare(this.m_tradingClass, contract.m_tradingClass) != 0) {
                return false;
            }
        }
        if (Util.StringCompare(this.m_secIdType, contract.m_secIdType) != 0) {
            return false;
        }
        if (Util.StringCompare(this.m_secId, contract.m_secId) != 0) {
            return false;
        }
        if (!Util.listsEqualUnordered(this.m_comboLegs, contract.m_comboLegs)) {
            return false;
        }
        if (this.m_deltaNeutralContract != contract.m_deltaNeutralContract) {
            if (this.m_deltaNeutralContract == null || contract.m_deltaNeutralContract == null) {
                return false;
            }
            if (!this.m_deltaNeutralContract.equals(contract.m_deltaNeutralContract)) {
                return false;
            }
        }
        if (Util.StringCompare(this.m_description, contract.m_description) != 0) {
            return false;
        }
        return Util.StringCompare(this.m_issuerId, contract.m_issuerId) == 0;
    }

    public int hashCode() {
        int n = this.m_conid;
        n = n * 31 + (this.m_symbol == null || "".equals(this.m_symbol) ? 0 : this.m_symbol.hashCode());
        long l = Double.doubleToLongBits(this.m_strike);
        n = n * 31 + (int)(l ^ l >>> 32);
        return n;
    }

    public String textDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isCombo()) {
            int n = 0;
            for (ComboLeg comboLeg : this.m_comboLegs) {
                if (n++ > 0) {
                    stringBuilder.append("/");
                }
                stringBuilder.append(comboLeg.toString());
            }
        } else {
            stringBuilder.append(this.m_symbol);
            Contract.app(stringBuilder, this.m_secType);
            Contract.app(stringBuilder, this.m_exchange);
            if (this.m_exchange != null && this.m_exchange.equals("SMART") && this.m_primaryExch != null) {
                Contract.app(stringBuilder, this.m_primaryExch);
            }
            Contract.app(stringBuilder, this.m_lastTradeDateOrContractMonth);
            Contract.app(stringBuilder, this.m_lastTradeDate);
            if (this.m_strike != 0.0) {
                Contract.app(stringBuilder, this.m_strike);
            }
            if (!Util.StringIsEmpty(this.m_right) && !this.m_right.equals("?")) {
                Contract.app(stringBuilder, this.m_right);
            }
            Contract.app(stringBuilder, this.m_currency);
        }
        return stringBuilder.toString();
    }

    private static void app(StringBuilder stringBuilder, Object object) {
        if (object != null) {
            stringBuilder.append(" ");
            stringBuilder.append(object);
        }
    }

    public boolean isCombo() {
        return this.m_comboLegs.size() > 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Contract.add(stringBuilder, "conid", this.m_conid);
        Contract.add(stringBuilder, "symbol", this.m_symbol);
        Contract.add(stringBuilder, "secType", this.m_secType);
        Contract.add(stringBuilder, "lastTradeDateOrContractMonth", this.m_lastTradeDateOrContractMonth);
        Contract.add(stringBuilder, "lastTradeDate", this.m_lastTradeDate);
        Contract.add(stringBuilder, "strike", this.m_strike);
        Contract.add(stringBuilder, "right", this.m_right);
        Contract.add(stringBuilder, "multiplier", this.m_multiplier);
        Contract.add(stringBuilder, "exchange", this.m_exchange);
        Contract.add(stringBuilder, "currency", this.m_currency);
        Contract.add(stringBuilder, "localSymbol", this.m_localSymbol);
        Contract.add(stringBuilder, "tradingClass", this.m_tradingClass);
        Contract.add(stringBuilder, "primaryExch", this.m_primaryExch);
        Contract.add(stringBuilder, "secIdType", this.m_secIdType);
        Contract.add(stringBuilder, "secId", this.m_secId);
        Contract.add(stringBuilder, "description", this.m_description);
        Contract.add(stringBuilder, "issuerId", this.m_issuerId);
        return stringBuilder.toString();
    }

    public static void add(StringBuilder stringBuilder, String string, Object object) {
        if (object == null || object instanceof String && ((String)object).length() == 0) {
            return;
        }
        stringBuilder.append(string);
        stringBuilder.append('\t');
        stringBuilder.append(object);
        stringBuilder.append('\n');
    }
}

